/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.utils;

import android.hardware.Camera;
import com.wlf.camerakit.view.CameraView;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class CameraUtils {
    private static Camera m_Camera;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile(byte[] bfile, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() || dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + "/" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return file;
        }
    }

    public static boolean flashControl(CameraView cameraView) {
        Camera.Parameters parameters = cameraView.getCamera().getParameters();
        if ("off".equals(parameters.getFlashMode())) {
            parameters.setFlashMode("torch");
            cameraView.getCamera().setParameters(parameters);
            return true;
        }
        if ("torch".equals(parameters.getFlashMode())) {
            parameters.setFlashMode("off");
            cameraView.getCamera().setParameters(parameters);
        }
        return false;
    }
}

