/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.view;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.hardware.display.DisplayManagerCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.wlf.camerakit.R;
import com.wlf.camerakit.listener.CameraListener;
import com.wlf.camerakit.utils.AspectRatio;
import com.wlf.camerakit.utils.CameraImpl;
import com.wlf.camerakit.utils.CenterCrop;
import com.wlf.camerakit.utils.DisplayOrientationDetector;
import com.wlf.camerakit.utils.PreviewImpl;
import com.wlf.camerakit.utils.Size;
import com.wlf.camerakit.utils.TextureViewPreview;
import com.wlf.camerakit.view.Camera1;
import com.wlf.camerakit.view.CameraTopRectView;
import com.wlf.camerakit.view.FocusMarkerLayout;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;

public class CameraView
extends FrameLayout {
    private int mFacing;
    private int mFlash;
    private int mFocus;
    private int mMethod;
    private int mZoom;
    private int mPermissions;
    private int mVideoQuality;
    private int mJpegQuality;
    private boolean mCropOutput;
    private boolean mAdjustViewBounds;
    private boolean isShowRectView;
    private CameraTopRectView topRectView;
    private CameraListenerMiddleWare mCameraListener;
    private DisplayOrientationDetector mDisplayOrientationDetector;
    public CameraImpl mCameraImpl;
    public PreviewImpl mPreviewImpl;

    public CameraView(@NonNull Context context) {
        super(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CameraView, 0, 0);
            try {
                this.mFacing = a.getInteger(R.styleable.CameraView_ckFacing, 0);
                this.mFlash = a.getInteger(R.styleable.CameraView_ckFlash, 0);
                this.mFocus = a.getInteger(R.styleable.CameraView_ckFocus, 1);
                this.mMethod = a.getInteger(R.styleable.CameraView_ckMethod, 0);
                this.mZoom = a.getInteger(R.styleable.CameraView_ckZoom, 0);
                this.mPermissions = a.getInteger(R.styleable.CameraView_ckPermissions, 0);
                this.mVideoQuality = a.getInteger(R.styleable.CameraView_ckVideoQuality, 0);
                this.mJpegQuality = a.getInteger(R.styleable.CameraView_ckJpegQuality, 100);
                this.mCropOutput = a.getBoolean(R.styleable.CameraView_ckCropOutput, false);
                this.mAdjustViewBounds = a.getBoolean(R.styleable.CameraView_android_adjustViewBounds, false);
            }
            finally {
                a.recycle();
            }
        }
        this.topRectView = new CameraTopRectView(context, attrs);
        this.mCameraListener = new CameraListenerMiddleWare();
        this.mPreviewImpl = new TextureViewPreview(context, (ViewGroup)this);
        this.mCameraImpl = new Camera1(this.mCameraListener, this.mPreviewImpl);
        this.setFacing(this.mFacing);
        this.setFlash(this.mFlash);
        this.setFocus(this.mFocus);
        this.setMethod(this.mMethod);
        this.setZoom(this.mZoom);
        this.setPermissions(this.mPermissions);
        this.setVideoQuality(this.mVideoQuality);
        this.mDisplayOrientationDetector = new DisplayOrientationDetector(context){

            @Override
            public void onDisplayOrientationChanged(int displayOrientation) {
                CameraView.this.mCameraImpl.setDisplayOrientation(displayOrientation);
                CameraView.this.mPreviewImpl.setDisplayOrientation(displayOrientation);
            }
        };
        final FocusMarkerLayout focusMarkerLayout = new FocusMarkerLayout(this.getContext());
        this.addView((View)focusMarkerLayout);
        focusMarkerLayout.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent motionEvent) {
                int action = motionEvent.getAction();
                if (motionEvent.getAction() == 1 && CameraView.this.mFocus == 3) {
                    focusMarkerLayout.focus(motionEvent.getX(), motionEvent.getY());
                }
                CameraView.this.mPreviewImpl.getView().dispatchTouchEvent(motionEvent);
                return true;
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mDisplayOrientationDetector.enable(ViewCompat.isAttachedToWindow((View)this) ? DisplayManagerCompat.getInstance((Context)this.getContext()).getDisplay(0) : null);
    }

    protected void onDetachedFromWindow() {
        this.mDisplayOrientationDetector.disable();
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mAdjustViewBounds) {
            Size previewSize = this.getPreviewSize();
            if (previewSize != null) {
                if (this.getLayoutParams().width == -2) {
                    int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
                    float ratio = (float)height / (float)previewSize.getWidth();
                    int width = (int)((float)previewSize.getHeight() * ratio);
                    super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), heightMeasureSpec);
                    return;
                }
                if (this.getLayoutParams().height == -2) {
                    int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
                    float ratio = (float)width / (float)previewSize.getHeight();
                    int height = (int)((float)previewSize.getWidth() * ratio);
                    super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
                    return;
                }
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void start() {
        int cameraCheck = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA");
        int audioCheck = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.RECORD_AUDIO");
        switch (this.mPermissions) {
            case 0: {
                if (cameraCheck == 0 && audioCheck == 0) break;
                this.requestPermissions(true, true);
                return;
            }
            case 1: {
                if (cameraCheck == 0) break;
                this.requestPermissions(true, true);
                return;
            }
            case 2: {
                if (cameraCheck == 0) break;
                this.requestPermissions(true, false);
                return;
            }
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                CameraView.this.mCameraImpl.start();
            }
        }).start();
    }

    public void stop() {
        this.mCameraImpl.stop();
    }

    public void setFacing(final int facing) {
        this.mFacing = facing;
        new Thread(new Runnable(){

            @Override
            public void run() {
                CameraView.this.mCameraImpl.setFacing(facing);
            }
        }).start();
    }

    public void setFlash(int flash) {
        this.mFlash = flash;
        this.mCameraImpl.setFlash(flash);
    }

    public void setFocus(int focus) {
        this.mFocus = focus;
        if (this.mFocus == 3) {
            this.mCameraImpl.setFocus(2);
            return;
        }
        this.mCameraImpl.setFocus(this.mFocus);
    }

    public void setMethod(int method) {
        this.mMethod = method;
        this.mCameraImpl.setMethod(this.mMethod);
    }

    public void setZoom(int zoom) {
        this.mZoom = zoom;
        this.mCameraImpl.setZoom(this.mZoom);
    }

    public void setPermissions(int permissions) {
        this.mPermissions = permissions;
    }

    public void setVideoQuality(int videoQuality) {
        this.mVideoQuality = videoQuality;
        this.mCameraImpl.setVideoQuality(this.mVideoQuality);
    }

    public void setJpegQuality(int jpegQuality) {
        this.mJpegQuality = jpegQuality;
    }

    public void setCropOutput(boolean cropOutput) {
        this.mCropOutput = cropOutput;
    }

    public int toggleFacing() {
        switch (this.mFacing) {
            case 0: {
                this.setFacing(1);
                break;
            }
            case 1: {
                this.setFacing(0);
            }
        }
        return this.mFacing;
    }

    public int toggleFlash() {
        switch (this.mFlash) {
            case 0: {
                this.setFlash(1);
                break;
            }
            case 1: {
                this.setFlash(2);
                break;
            }
            case 2: {
                this.setFlash(0);
            }
        }
        return this.mFlash;
    }

    public Camera getCamera() {
        return ((Camera1)this.mCameraImpl).mCamera;
    }

    public void setCameraListener(CameraListener cameraListener) {
        this.mCameraListener.setCameraListener(cameraListener);
    }

    public void setShowRectView(boolean isShowRectView) {
        this.isShowRectView = isShowRectView;
    }

    public boolean getIsShowRectView() {
        return this.isShowRectView;
    }

    public void captureImage() {
        this.mCameraImpl.captureImage();
    }

    public void startRecordingVideo() {
        this.mCameraImpl.startVideo();
    }

    public void stopRecordingVideo() {
        this.mCameraImpl.endVideo();
    }

    public Size getPreviewSize() {
        return this.mCameraImpl != null ? this.mCameraImpl.getPreviewResolution() : null;
    }

    public Size getCaptureSize() {
        return this.mCameraImpl != null ? this.mCameraImpl.getCaptureResolution() : null;
    }

    private void requestPermissions(boolean requestCamera, boolean requestAudio) {
        Activity activity = null;
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                activity = (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        ArrayList<String> permissions = new ArrayList<String>();
        if (requestCamera) {
            permissions.add("android.permission.CAMERA");
        }
        if (requestAudio) {
            permissions.add("android.permission.RECORD_AUDIO");
        }
        if (activity != null) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])permissions.toArray(new String[permissions.size()]), (int)16);
        }
    }

    public byte[] getBitmapByte(byte[] bytes) {
        if (!this.isShowRectView) {
            return bytes;
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        Bitmap sizeBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.topRectView.getViewWidth(), (int)this.topRectView.getViewHeight(), (boolean)true);
        Bitmap bmp = Bitmap.createBitmap((Bitmap)sizeBitmap, (int)this.topRectView.getRectLeft(), (int)this.topRectView.getRectTop(), (int)(this.topRectView.getRectRight() - this.topRectView.getRectLeft()), (int)(this.topRectView.getRectBottom() - this.topRectView.getRectTop()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        byte[] datas = baos.toByteArray();
        return datas;
    }

    private class CameraListenerMiddleWare
    extends CameraListener {
        private CameraListener mCameraListener;

        private CameraListenerMiddleWare() {
        }

        @Override
        public void onCameraOpened() {
            super.onCameraOpened();
            this.getCameraListener().onCameraOpened();
        }

        @Override
        public void onCameraClosed() {
            super.onCameraClosed();
            this.getCameraListener().onCameraClosed();
        }

        @Override
        public void onPictureTaken(byte[] jpeg) {
            super.onPictureTaken(jpeg);
            if (CameraView.this.mCropOutput) {
                int width = CameraView.this.mMethod == 0 ? CameraView.this.mCameraImpl.getCaptureResolution().getWidth() : CameraView.this.mCameraImpl.getPreviewResolution().getWidth();
                int height = CameraView.this.mMethod == 0 ? CameraView.this.mCameraImpl.getCaptureResolution().getHeight() : CameraView.this.mCameraImpl.getPreviewResolution().getHeight();
                AspectRatio outputRatio = AspectRatio.of(CameraView.this.getWidth(), CameraView.this.getHeight());
                byte[] b = new CenterCrop(jpeg, outputRatio, CameraView.this.mJpegQuality).getJpeg();
                this.getCameraListener().onPictureTaken(CameraView.this.getBitmapByte(b));
            } else {
                this.getCameraListener().onPictureTaken(CameraView.this.getBitmapByte(jpeg));
            }
        }

        @Override
        public void onPictureTaken(YuvImage yuv) {
            super.onPictureTaken(yuv);
            if (CameraView.this.mCropOutput) {
                AspectRatio outputRatio = AspectRatio.of(CameraView.this.getWidth(), CameraView.this.getHeight());
                this.getCameraListener().onPictureTaken(new CenterCrop(yuv, outputRatio, CameraView.this.mJpegQuality).getJpeg());
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                yuv.compressToJpeg(new Rect(0, 0, yuv.getWidth(), yuv.getHeight()), CameraView.this.mJpegQuality, (OutputStream)out);
                this.getCameraListener().onPictureTaken(out.toByteArray());
            }
        }

        @Override
        public void onVideoTaken(File video) {
            super.onVideoTaken(video);
            this.getCameraListener().onVideoTaken(video);
        }

        public void setCameraListener(@Nullable CameraListener cameraListener) {
            this.mCameraListener = cameraListener;
        }

        @NonNull
        public CameraListener getCameraListener() {
            return this.mCameraListener != null ? this.mCameraListener : new CameraListener(){};
        }
    }
}

