/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.utils;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import com.wlf.camerakit.utils.AspectRatio;

public abstract class PreviewImpl {
    private Callback mCallback;
    private int mWidth;
    private int mHeight;
    protected int mTrueWidth;
    protected int mTrueHeight;

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public abstract Surface getSurface();

    public abstract View getView();

    public abstract Class getOutputClass();

    public abstract void setDisplayOrientation(int var1);

    public abstract boolean isReady();

    public void dispatchSurfaceChanged() {
        this.mCallback.onSurfaceChanged();
    }

    public SurfaceHolder getSurfaceHolder() {
        return null;
    }

    public SurfaceTexture getSurfaceTexture() {
        return null;
    }

    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.setTruePreviewSize(this.mTrueWidth, this.mTrueHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setTruePreviewSize(final int width, final int height) {
        this.mTrueWidth = width;
        this.mTrueHeight = height;
        this.getView().post(new Runnable(){

            @Override
            public void run() {
                if (width != 0 && height != 0) {
                    AspectRatio aspectRatio = AspectRatio.of(width, height);
                    int targetHeight = (int)((float)PreviewImpl.this.getView().getWidth() * aspectRatio.toFloat());
                    float scaleY = PreviewImpl.this.getView().getHeight() > 0 ? (float)targetHeight / (float)PreviewImpl.this.getView().getHeight() : 1.0f;
                    if (scaleY > 1.0f) {
                        PreviewImpl.this.getView().setScaleX(1.0f);
                        PreviewImpl.this.getView().setScaleY(scaleY);
                    } else {
                        PreviewImpl.this.getView().setScaleX(1.0f / scaleY);
                        PreviewImpl.this.getView().setScaleY(1.0f);
                    }
                }
            }
        });
    }

    public int getTrueWidth() {
        return this.mTrueWidth;
    }

    public int getTrueHeight() {
        return this.mTrueHeight;
    }

    public static interface Callback {
        public void onSurfaceChanged();
    }
}

