/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import com.wlf.camerakit.utils.AspectRatio;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CenterCrop {
    private byte[] croppedJpeg;

    public CenterCrop(YuvImage yuv, AspectRatio targetRatio, int jpegCompression) {
        Rect crop = CenterCrop.getCrop(yuv.getWidth(), yuv.getHeight(), targetRatio);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        yuv.compressToJpeg(crop, jpegCompression, (OutputStream)out);
        this.croppedJpeg = out.toByteArray();
    }

    public CenterCrop(byte[] jpeg, AspectRatio targetRatio, int jpegCompression) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])jpeg, (int)0, (int)jpeg.length, (BitmapFactory.Options)options);
        Rect crop = CenterCrop.getCrop(options.outWidth, options.outHeight, targetRatio);
        try {
            Bitmap bitmap = BitmapRegionDecoder.newInstance((byte[])jpeg, (int)0, (int)jpeg.length, (boolean)true).decodeRegion(crop, null);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, jpegCompression, (OutputStream)out);
            this.croppedJpeg = out.toByteArray();
        }
        catch (IOException e) {
            Log.e((String)"CameraKit", (String)e.toString());
        }
    }

    private static Rect getCrop(int currentWidth, int currentHeight, AspectRatio targetRatio) {
        Rect crop;
        AspectRatio currentRatio = AspectRatio.of(currentWidth, currentHeight);
        if (currentRatio.toFloat() > targetRatio.toFloat()) {
            int width = (int)((float)currentHeight * targetRatio.toFloat());
            int widthOffset = (currentWidth - width) / 2;
            crop = new Rect(widthOffset, 0, currentWidth - widthOffset, currentHeight);
        } else {
            int height = (int)((float)currentWidth * targetRatio.inverse().toFloat());
            int heightOffset = (currentHeight - height) / 2;
            crop = new Rect(0, heightOffset, currentWidth, currentHeight - heightOffset);
        }
        return crop;
    }

    public byte[] getJpeg() {
        return this.croppedJpeg;
    }
}

