/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.io;

import com.wizzardo.tools.io.FileTools;
import com.wizzardo.tools.io.IOTools;
import com.wizzardo.tools.misc.Unchecked;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipTools {
    public static List<File> unzip(File zipFile, File outDir) {
        return ZipTools.unzip(zipFile, outDir, null);
    }

    public static List<File> unzip(File zipFile, File outDir, ZipEntryFilter filter) {
        ZipInputStream zip = null;
        outDir.mkdirs();
        ArrayList<File> l = new ArrayList<File>();
        try {
            ZipEntry entry;
            zip = new ZipInputStream(new FileInputStream(zipFile));
            byte[] b = new byte[51200];
            while ((entry = zip.getNextEntry()) != null) {
                File outFile = new File(outDir, entry.getName());
                if (entry.isDirectory() || filter != null && !filter.accept(entry)) continue;
                outFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outFile);
                try {
                    IOTools.copy(zip, out, b);
                    l.add(outFile);
                }
                catch (IOException ex) {
                    outFile.delete();
                    throw Unchecked.rethrow((Exception)ex);
                }
                finally {
                    IOTools.close(out);
                }
            }
        }
        catch (IOException ex) {
            try {
                throw Unchecked.rethrow((Exception)ex);
            }
            catch (Throwable throwable) {
                IOTools.close(zip);
                throw throwable;
            }
        }
        IOTools.close(zip);
        return l;
    }

    public static boolean isZip(File f) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        byte[] b = new byte[2];
        try {
            in.read(b);
        }
        catch (IOException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
        finally {
            IOTools.close(in);
        }
        return ZipTools.isZip(b);
    }

    public static boolean isZip(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && bytes[0] == 80 && bytes[1] == 75;
    }

    public static File zip(String file) {
        return ZipTools.zip(new File(file));
    }

    public static File zip(File toZip) {
        ZipOutputStream zipout = null;
        File zip = new File(toZip.getAbsolutePath() + ".zip");
        try {
            zipout = new ZipOutputStream(new FileOutputStream(zip));
            ZipTools.zip(zipout, toZip);
        }
        catch (IOException ex) {
            try {
                throw Unchecked.rethrow((Exception)ex);
            }
            catch (Throwable throwable) {
                IOTools.close(zipout);
                throw throwable;
            }
        }
        IOTools.close(zipout);
        return zip;
    }

    public static void zip(ZipOutputStream out, File toZip) {
        File startDir = toZip.getParentFile();
        ZipTools.zipping(out, FileTools.listRecursive(toZip), startDir);
    }

    public static void zipping(ZipOutputStream zipout, List<File> files, File startDir) {
        FileInputStream in = null;
        byte[] b = new byte[51200];
        for (int i = 1; i <= files.size(); ++i) {
            try {
                File f = files.get(i - 1);
                in = new FileInputStream(f);
                ZipEntry entry = new ZipEntry(f.getAbsolutePath().substring(startDir.getAbsolutePath().length() + 1));
                entry.setMethod(8);
                zipout.putNextEntry(entry);
                IOTools.copy(in, zipout, b);
            }
            catch (IOException ex) {
                try {
                    throw Unchecked.rethrow((Exception)ex);
                }
                catch (Throwable throwable) {
                    IOTools.close(in);
                    throw throwable;
                }
            }
            IOTools.close(in);
        }
    }

    public static interface ZipEntryFilter {
        public boolean accept(ZipEntry var1);
    }

    public static class FileEntry
    implements ZipBuilderEntry {
        private File file;

        public FileEntry(String file) {
            this(new File(file));
        }

        public FileEntry(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ZipOutputStream out) throws IOException {
            block3: {
                block2: {
                    if (!this.file.isFile()) break block2;
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(this.file);
                        ZipEntry entry = new ZipEntry(this.file.getName());
                        entry.setMethod(8);
                        out.putNextEntry(entry);
                        IOTools.copy(in, out);
                    }
                    catch (Throwable throwable) {
                        IOTools.close(in);
                        throw throwable;
                    }
                    IOTools.close(in);
                    break block3;
                }
                ZipTools.zip(out, this.file);
            }
        }
    }

    public static class StreamEntry
    implements ZipBuilderEntry {
        private String name;
        private InputStream stream;

        public StreamEntry(String name, InputStream stream) {
            this.name = name;
            this.stream = stream;
        }

        @Override
        public void write(ZipOutputStream out) throws IOException {
            ZipEntry entry = new ZipEntry(this.name);
            entry.setMethod(8);
            out.putNextEntry(entry);
            IOTools.copy(this.stream, out);
        }
    }

    public static class BytesEntry
    implements ZipBuilderEntry {
        private String name;
        private byte[] bytes;
        private int offset;
        private int length;

        public BytesEntry(String name, byte[] bytes) {
            this(name, bytes, 0, bytes.length);
        }

        public BytesEntry(String name, byte[] bytes, int offset, int length) {
            this.name = name;
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public void write(ZipOutputStream out) throws IOException {
            ZipEntry entry = new ZipEntry(this.name);
            entry.setMethod(8);
            out.putNextEntry(entry);
            out.write(this.bytes, this.offset, this.length);
        }
    }

    public static interface ZipBuilderEntry {
        public void write(ZipOutputStream var1) throws IOException;
    }

    public static class ZipBuilder {
        private List<ZipBuilderEntry> entries = new ArrayList<ZipBuilderEntry>();
        private int level = -1;
        private int method = 8;

        public ZipBuilder append(String name, byte[] bytes) {
            return this.append(new BytesEntry(name, bytes));
        }

        public ZipBuilder append(File f) {
            return this.append(new FileEntry(f));
        }

        public ZipBuilder append(String name, InputStream in) {
            return this.append(new StreamEntry(name, in));
        }

        public ZipBuilder append(ZipBuilderEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public void zip(File out) throws IOException {
            this.zip(new FileOutputStream(out));
        }

        public ZipBuilder level(int level) {
            if (level < 0 || level > 9) {
                throw new IllegalArgumentException("compression level must be 0-9");
            }
            this.level = level;
            return this;
        }

        public ZipBuilder method(int method) {
            if (method != 8 && method != 0) {
                throw new IllegalArgumentException("compression method must be on of [DEFLATED, STORED]");
            }
            this.method = method;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zip(OutputStream out) throws IOException {
            ZipWriter writer = new ZipWriter(out).setLevel(this.level).setMethod(this.method);
            try {
                for (ZipBuilderEntry entry : this.entries) {
                    writer.write(entry);
                }
            }
            finally {
                IOTools.close(writer);
            }
        }
    }

    public static class ZipWriter
    implements Closeable {
        protected ZipOutputStream out;

        public ZipWriter(String file) throws IOException {
            this(new FileOutputStream(file));
        }

        public ZipWriter(File file) throws IOException {
            this(new FileOutputStream(file));
        }

        public ZipWriter(OutputStream outputStream) throws IOException {
            this.out = new ZipOutputStream(outputStream);
        }

        public ZipWriter setLevel(int level) {
            this.out.setLevel(level);
            return this;
        }

        public ZipWriter setMethod(int method) {
            this.out.setMethod(method);
            return this;
        }

        public ZipWriter write(ZipBuilderEntry entry) throws IOException {
            this.out.closeEntry();
            entry.write(this.out);
            return this;
        }

        public ZipWriter flush() throws IOException {
            this.out.flush();
            return this;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

