/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.io;

import com.wizzardo.tools.io.IOTools;
import com.wizzardo.tools.misc.Unchecked;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class FileTools {
    public static final Charset UTF_8 = Charset.forName("utf-8");

    public static byte[] bytes(String file) {
        return FileTools.bytes(new File(file));
    }

    public static String text(String file) {
        return FileTools.text(new File(file), UTF_8);
    }

    public static String text(File file) {
        return FileTools.text(file, UTF_8);
    }

    public static void text(String file, String text) {
        FileTools.text(file, text, UTF_8);
    }

    public static void text(File file, String text) {
        FileTools.text(file, text, UTF_8);
    }

    public static void text(String file, String text, Charset charset) {
        FileTools.text(new File(file), text, charset);
    }

    public static void text(File file, String text, Charset charset) {
        FileTools.bytes(file, text.getBytes(charset));
    }

    public static String text(String file, Charset charset) {
        return FileTools.text(new File(file), charset);
    }

    public static String text(File file, Charset charset) {
        return new String(FileTools.bytes(file), charset);
    }

    public static void bytes(String file, byte[] bytes) {
        FileTools.bytes(new File(file), bytes, 0, bytes.length);
    }

    public static void bytes(File file, byte[] bytes) {
        FileTools.bytes(file, bytes, 0, bytes.length);
    }

    public static void bytes(String file, byte[] bytes, int offset, int length) {
        FileTools.bytes(new File(file), bytes, offset, length);
    }

    public static void bytes(String file, InputStream stream) {
        FileTools.bytes(new File(file), stream);
    }

    public static void bytes(File file, InputStream stream) {
        FileOutputStream out;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        try {
            IOTools.copy(stream, out);
        }
        catch (IOException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        finally {
            IOTools.close(out);
        }
    }

    public static void bytes(File file, byte[] bytes, int offset, int length) {
        FileOutputStream out;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        try {
            out.write(bytes, offset, length);
        }
        catch (IOException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        finally {
            IOTools.close(out);
        }
    }

    public static byte[] bytes(File file) {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        byte[] b = new byte[(int)file.length()];
        int total = 0;
        try {
            int r;
            while (b.length - total > 0 && (r = ((InputStream)in).read(b, total, b.length - total)) != -1) {
                total += r;
            }
        }
        catch (IOException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        finally {
            IOTools.close(in);
        }
        return b;
    }

    public static List<File> listRecursive(File f) {
        return FileTools.listRecursive(f, new ArrayList<File>(), null);
    }

    public static List<File> listRecursive(File f, FileFilter filter) {
        return FileTools.listRecursive(f, new ArrayList<File>(), filter);
    }

    public static List<File> listRecursive(File f, List<File> into, FileFilter filter) {
        if (f == null) {
            return into;
        }
        if (!f.isDirectory() && f.exists()) {
            into.add(f);
        } else {
            File[] l = f.listFiles(filter);
            if (l != null) {
                for (File file : l) {
                    FileTools.listRecursive(file, into, filter);
                }
            }
        }
        return into;
    }

    public static void deleteRecursive(File f) {
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                FileTools.deleteRecursive(file);
            }
        }
        f.delete();
    }
}

