/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.io;

import java.nio.charset.Charset;
import java.util.Arrays;

public class BoyerMoore {
    protected static final Charset UTF8 = Charset.forName("utf-8");
    protected static final int ALPHABET_SIZE = 256;
    private final int[] charTable;
    private final int[] offsetTable;
    private final byte[] needle;

    public BoyerMoore(String s) {
        this(s.getBytes(UTF8));
    }

    public BoyerMoore(byte[] needle) {
        this(needle, 0, needle.length);
    }

    public BoyerMoore(byte[] needle, int offset, int length) {
        if (needle == null || length == 0) {
            throw new IllegalArgumentException();
        }
        this.needle = Arrays.copyOfRange(needle, offset, offset + length);
        this.charTable = BoyerMoore.makeCharTable(needle);
        this.offsetTable = BoyerMoore.makeOffsetTable(needle);
    }

    public int search(byte[] haystack) {
        return this.search(haystack, 0, haystack.length);
    }

    public int search(byte[] haystack, int offset, int length) {
        int j;
        byte[] needle = this.needle;
        int needleLength = needle.length - 1;
        int limit = offset + length;
        for (int i = needleLength + offset; i < limit; i += Math.max(this.offsetTable[needleLength - j], this.charTable[haystack[i] & 0xFF])) {
            j = needleLength;
            while (needle[j] == haystack[i]) {
                if (j == 0) {
                    return i;
                }
                --i;
                --j;
            }
        }
        return -1;
    }

    private static int[] makeCharTable(byte[] needle) {
        int i;
        int[] table = new int[256];
        int l = needle.length;
        for (i = 0; i < 256; ++i) {
            table[i] = l;
        }
        --l;
        for (i = 0; i < l; ++i) {
            table[needle[i] & 0xFF] = l - i;
        }
        return table;
    }

    private static int[] makeOffsetTable(byte[] needle) {
        int i;
        int l = needle.length;
        int[] table = new int[l];
        int lastPrefixPosition = l;
        for (i = l - 1; i >= 0; --i) {
            if (BoyerMoore.isPrefix(needle, i + 1)) {
                lastPrefixPosition = i + 1;
            }
            table[l - 1 - i] = lastPrefixPosition - i + l - 1;
        }
        for (i = 0; i < l - 1; ++i) {
            int slen = BoyerMoore.suffixLength(needle, i);
            table[slen] = l - 1 - i + slen;
        }
        return table;
    }

    private static boolean isPrefix(byte[] needle, int p) {
        int l = needle.length;
        int i = p;
        int j = 0;
        while (i < l) {
            if (needle[i] != needle[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static int suffixLength(byte[] needle, int p) {
        int len = 0;
        int i = p;
        int j = needle.length - 1;
        while (i >= 0 && needle[i] == needle[j]) {
            ++len;
            --i;
            --j;
        }
        return len;
    }
}

