/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.io;

import com.wizzardo.tools.io.BoyerMoore;
import com.wizzardo.tools.io.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockInputStream
extends InputStream {
    private PushbackInputStream in;
    private byte[] buffer;
    private byte[] dynamicBuffer;
    private boolean close = false;
    private byte[] separator;
    private boolean wait = true;
    private int findedIndex = -1;
    private int offset = 0;
    private int r;
    private int endimg;
    private int buffered;
    private BoyerMoore bm;
    private long blockLength = 0L;
    private long limit = 0L;
    private long totalRead = 0L;
    private ProgressListener progressListener;

    public BlockInputStream(InputStream in, byte[] separator) {
        this.separator = Arrays.copyOf(separator, separator.length);
        this.in = new PushbackInputStream(in, 51200);
        this.buffer = new byte[separator.length];
        this.bm = new BoyerMoore(separator);
    }

    public BlockInputStream(InputStream in, byte[] separator, long limit) {
        this(in, separator);
        this.limit = limit;
    }

    public BlockInputStream(InputStream in, byte[] separator, long limit, ProgressListener progressListener) {
        this(in, separator, limit);
        this.progressListener = progressListener;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.wait) {
            throw new IllegalStateException("this method can be executed only between blocks");
        }
        if (this.dynamicBuffer != null) {
            this.in.unread(this.dynamicBuffer, this.offset, this.dynamicBuffer.length - this.offset);
        }
        return this.in;
    }

    public boolean hasNext() throws IOException {
        if (this.limitReached()) {
            return false;
        }
        return this.dynamicBuffer != null || this.ready();
    }

    public void next() {
        this.wait = false;
        this.blockLength = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.limitReached()) {
            return -1;
        }
        byte[] bytes = new byte[1];
        int r = this.read(bytes);
        if (r == 0) {
            return -1;
        }
        return bytes[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private boolean limitReached() {
        return this.dynamicBuffer == null && this.limit > 0L && this.totalRead >= this.limit;
    }

    @Override
    public int read(byte[] b, int off, int l) throws IOException {
        if (this.limitReached()) {
            return -1;
        }
        if (l < this.separator.length) {
            throw new IllegalArgumentException("byte array MUST be bigger then separator");
        }
        if (this.wait) {
            return -1;
        }
        if (this.dynamicBuffer != null) {
            int k = this.dynamicBuffer.length - this.offset;
            if (k >= l) {
                System.arraycopy(this.dynamicBuffer, this.offset, b, off, l);
                this.offset += l;
                if (this.offset == this.dynamicBuffer.length) {
                    this.dynamicBuffer = null;
                    this.offset = 0;
                }
                this.r = l;
            } else {
                System.arraycopy(this.dynamicBuffer, this.offset, b, off, k);
                this.dynamicBuffer = null;
                this.offset = 0;
                this.r = k;
            }
        } else if (this.buffered > 0) {
            System.arraycopy(this.buffer, 0, b, off, this.buffered);
            this.r = this.in.read(b, this.buffered + off, l - this.buffered);
            if (this.r != -1) {
                this.r += this.buffered;
                this.totalRead += (long)this.r;
            } else {
                this.r = this.buffered;
            }
            this.buffered = 0;
        } else if (this.ready()) {
            this.r = this.in.read(b, off, l);
            this.totalRead += (long)this.r;
        } else {
            this.r = -1;
        }
        if (this.progressListener != null) {
            if (this.totalRead != this.limit) {
                this.progressListener.setProgress((int)((float)this.totalRead * 100.0f / (float)this.limit));
            } else {
                this.progressListener.setProgress(100);
            }
        }
        if (this.r != -1) {
            this.findedIndex = this.bm.search(b, off, this.r);
            if (this.findedIndex != -1) {
                this.wait = true;
                int length = this.r - this.findedIndex - this.separator.length + off;
                if (length != 0) {
                    this.dynamicBuffer = new byte[length];
                    System.arraycopy(b, this.findedIndex + this.separator.length, this.dynamicBuffer, 0, this.dynamicBuffer.length);
                }
                this.blockLength += (long)this.findedIndex;
                return this.findedIndex - off;
            }
            this.endimg = BlockInputStream.isEnding(b, this.r, this.separator);
            if (this.endimg != -1) {
                this.buffered = this.r - this.endimg;
                System.arraycopy(b, this.endimg, this.buffer, 0, this.buffered);
                this.blockLength += (long)this.endimg;
                return this.endimg;
            }
            this.blockLength += (long)this.r;
            return this.r;
        }
        return -1;
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.close = true;
        this.in = null;
    }

    public static int isEnding(byte[] b, int length, byte[] endsWith) {
        int i = length - endsWith.length;
        if (i < 0) {
            i = 0;
        }
        while (i < length) {
            int j;
            for (j = 0; j < endsWith.length && j + i < length && b[i + j] == endsWith[j]; ++j) {
            }
            if (j + i == length) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int endOfBlock(byte[] b, int offset, int length) {
        int i = offset;
        if (i < 0) {
            i = 0;
        }
        while (i <= length - this.separator.length) {
            int j;
            for (j = 0; j < this.separator.length && b[i + j] == this.separator[j]; ++j) {
            }
            if (j == this.separator.length) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean ready() throws IOException {
        if (!this.close && (this.dynamicBuffer == null || this.limit > 0L && this.totalRead < this.limit)) {
            int r;
            for (long wait = 0L; (r = this.in.read()) == -1 && wait < 500L; ++wait) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BlockInputStream.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (r == -1) {
                return false;
            }
            this.in.unread(r);
            return true;
        }
        return false;
    }
}

