/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.MysqldExecutable;
import com.wix.mysql.SqlScriptSource;
import com.wix.mysql.config.Charset;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.exceptions.CommandFailedException;
import com.wix.mysql.utils.Utils;
import de.flapdoodle.embed.process.distribution.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

class MysqlClient {
    private final MysqldConfig config;
    private final MysqldExecutable executable;
    private final String schemaName;
    private final Charset effectiveCharset;

    public MysqlClient(MysqldConfig config, MysqldExecutable executable, String schemaName, Charset effectiveCharset) {
        this.config = config;
        this.executable = executable;
        this.schemaName = schemaName;
        this.effectiveCharset = effectiveCharset;
    }

    List<String> executeScripts(List<SqlScriptSource> sqls) {
        ArrayList<String> res = new ArrayList<String>(sqls.size());
        try {
            for (SqlScriptSource sql : sqls) {
                res.add(this.execute(sql.read()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public List<String> executeCommands(String ... sqls) {
        ArrayList<String> res = new ArrayList<String>(sqls.length);
        for (String sql : sqls) {
            res.add(this.execute(sql));
        }
        return res;
    }

    private String execute(String sql) {
        String command = Platform.detect() == Platform.Windows ? String.format("\"%s\"", sql) : sql;
        String out = "";
        try {
            Process p = new ProcessBuilder(Paths.get(this.executable.getBaseDir().getAbsolutePath(), "bin", "mysql").toString(), "--protocol=tcp", "--host=localhost", "--password=", String.format("--default-character-set=%s", this.effectiveCharset.getCharset()), String.format("--user=%s", "root"), String.format("--port=%s", this.config.getPort()), this.schemaName).start();
            if (!p.isAlive()) {
                String err = IOUtils.toString((InputStream)p.getErrorStream());
                throw new CommandFailedException(command, this.schemaName, p.exitValue(), err);
            }
            IOUtils.copy((Reader)new StringReader(sql), (OutputStream)p.getOutputStream(), (java.nio.charset.Charset)java.nio.charset.Charset.defaultCharset());
            p.getOutputStream().close();
            out = IOUtils.toString((InputStream)p.getInputStream());
            if (p.waitFor() != 0) {
                String err = IOUtils.toString((InputStream)p.getErrorStream());
                if (Utils.isNullOrEmpty(out)) {
                    throw new CommandFailedException(command, this.schemaName, p.waitFor(), err);
                }
                throw new CommandFailedException(command, this.schemaName, p.waitFor(), out);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new CommandFailedException(command, this.schemaName, e.getMessage(), e);
        }
        return out;
    }
}

