/*
 * Decompiled with CFR 0.152.
 */
package com.wiris.plugin.dispatchers;

import com.wiris.plugin.LibWIRIS;
import com.wiris.plugin.storage.StorageAndCache;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ShowImageDispatcher {
    private static Hashtable getConfigurationAndFonts(Properties config, String content) throws Exception {
        BufferedReader formulaBufferedReader = new BufferedReader(new StringReader(content));
        String mathml = "";
        Properties fonts = new Properties();
        try {
            String line = formulaBufferedReader.readLine();
            if (line != null) {
                int i;
                mathml = line.trim();
                for (i = 0; (line = formulaBufferedReader.readLine()) != null && i < LibWIRIS.xmlFileAttributes.length; ++i) {
                    config.setProperty(LibWIRIS.imageConfigProperties.getProperty(LibWIRIS.xmlFileAttributes[i]), line.trim());
                }
                i = 0;
                while ((line = formulaBufferedReader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    fonts.setProperty("font" + i, line);
                    ++i;
                }
                Hashtable<String, Object> toReturn = new Hashtable<String, Object>();
                toReturn.put("mathml", mathml);
                toReturn.put("config", config);
                toReturn.put("fonts", fonts);
                return toReturn;
            }
            throw new Exception("Empty content");
        }
        catch (IOException e) {
            throw new Exception("Error: the formula content can not be readed.");
        }
    }

    private static Hashtable getConfigurationAndFontsFromIni(Properties config, String content) throws Exception {
        Properties formulaConfig = new Properties();
        try {
            formulaConfig.load(new ByteArrayInputStream(content.getBytes("UTF-8")));
            Properties fonts = new Properties();
            for (String string : formulaConfig.keySet()) {
                if (string.equals("mml")) continue;
                if (string.length() >= 4 && string.substring(0, 4).equals("font")) {
                    fonts.setProperty(string, formulaConfig.getProperty(string).trim());
                    continue;
                }
                config.setProperty(string, formulaConfig.getProperty(string).trim());
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("mathml", formulaConfig.getProperty("mml").trim());
            hashtable.put("config", config);
            hashtable.put("fonts", fonts);
            return hashtable;
        }
        catch (IOException e) {
            throw new Exception("Error: the formula content can not be readed.");
        }
    }

    private static byte[] createImage(Properties config, StorageAndCache storage, String digest, String referer) throws Exception {
        String content = storage.decodeDigest(digest);
        if (content == null) {
            throw new Exception("Error: the formula has not been created.");
        }
        Hashtable configAndFonts = content.startsWith("<") ? ShowImageDispatcher.getConfigurationAndFonts(config, content) : ShowImageDispatcher.getConfigurationAndFontsFromIni(config, content);
        config = (Properties)configAndFonts.get("config");
        if (!config.containsKey("wirisimagenumbercolor") && config.containsKey("wirisimagesymbolcolor")) {
            config.setProperty("wirisimagenumbercolor", config.getProperty("wirisimagesymbolcolor"));
        }
        if (!config.containsKey("wirisimageidentcolor") && config.containsKey("wirisimagesymbolcolor")) {
            config.setProperty("wirisimageidentcolor", config.getProperty("wirisimagesymbolcolor"));
        }
        Properties properties = new Properties();
        properties.setProperty("mml", (String)configAndFonts.get("mathml"));
        for (String string : LibWIRIS.imageConfigProperties.keySet()) {
            String configKey = LibWIRIS.imageConfigProperties.getProperty(string);
            String string2 = config.getProperty(configKey);
            if (string2 == null) continue;
            properties.setProperty(string, string2.trim());
        }
        Properties properties2 = (Properties)configAndFonts.get("fonts");
        String fontRangesString = config.getProperty("wirisimagefontranges");
        if (fontRangesString != null) {
            int n = properties2.size();
            int j = 0;
            StringTokenizer tokens = new StringTokenizer(fontRangesString, ",");
            while (tokens.hasMoreElements()) {
                String rangeName = ((String)tokens.nextElement()).trim();
                String range = config.getProperty(rangeName);
                if (range == null) continue;
                properties2.setProperty("font" + (n + j), range.trim());
                ++j;
            }
        }
        for (String string : properties2.keySet()) {
            properties.setProperty(string, properties2.getProperty(string));
        }
        URL uRL = LibWIRIS.getImageServiceURL(config, null);
        BufferedInputStream httpInput = new BufferedInputStream(LibWIRIS.getContents(uRL, properties, referer));
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        LibWIRIS.flow(httpInput, dataStream);
        byte[] data = dataStream.toByteArray();
        storage.storeData(digest, data);
        return data;
    }

    public static void dispatch(Properties config, HttpServletRequest request, HttpServletResponse response, StorageAndCache storage) throws ServletException, IOException {
        String digest = request.getParameter("formula");
        if (digest == null) {
            PrintWriter out = response.getWriter();
            out.print("Error: no image name has been sended.");
            out.close();
        } else {
            ServletOutputStream out = response.getOutputStream();
            byte[] data = storage.retreiveData(digest);
            try {
                if (data == null) {
                    data = ShowImageDispatcher.createImage(config, storage, digest, LibWIRIS.getReferer(request));
                }
                response.setContentType("image/png");
                out.write(data);
            }
            catch (Exception e) {
                out.print(e.getMessage());
            }
            out.close();
        }
    }
}

