package com.wiris.plugin.dispatchers;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.wiris.plugin.LibWIRIS;
import com.wiris.plugin.storage.StorageAndCache;

public abstract class ShowCASImageDispatcher {
    public static void dispatch(ServletContext context, HttpServletRequest request, HttpServletResponse response, 
                                StorageAndCache storage) throws ServletException, IOException {
        String digest = request.getParameter("formula");

        if (digest == null) {
            PrintWriter out = response.getWriter();
            out.print("Error: no image name has been sended.");
            out.close();
        } else {
            if (digest.endsWith(".png")) {
                digest = digest.substring(0, digest.length() - 4);
            }

            ServletOutputStream out = response.getOutputStream();
            byte[] data = storage.retreiveData(digest);

            if (data != null) {
                response.setContentType("image/png");
                out.write(data);
            } else {
                response.setContentType("image/gif");
                LibWIRIS.flow(context.getResourceAsStream("/cas.gif"), out);
            }

            out.close();
        }
    }
}
