package com.wiris.plugin.dispatchers;

import com.wiris.plugin.LibWIRIS;
import com.wiris.plugin.storage.StorageAndCache;

import java.io.IOException;
import java.io.PrintWriter;

import java.net.URLEncoder;

import java.util.Enumeration;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public abstract class CreateImageDispatcher {
    public static void dispatch(HttpServletRequest request, HttpServletResponse response, 
                                StorageAndCache storage) throws IOException {
        response.setContentType("text/plain; charset=utf-8");
        PrintWriter out = response.getWriter();
        String mmlParameter = request.getParameter("mml");

        if (mmlParameter != null && mmlParameter.length() > 0) {
            Properties properties = new Properties();

            // Java + IIS hack: IIS parses the POST variables and applies a security filter that replaces all XML tags to its entities. We need to avoid this behaviour.

            if (mmlParameter.trim().startsWith("&lt;")) {
                mmlParameter = 
                        mmlParameter.replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&amp;", "&");
            }

            properties.setProperty("mml", mmlParameter);
            Enumeration<String> i = request.getParameterNames();

            while (i.hasMoreElements()) {
                String key = i.nextElement();

                if (LibWIRIS.inArray(key, LibWIRIS.xmlFileAttributes) || 
                    (key.length() >= 4 && key.substring(0, 4).equals("font"))) {
                    properties.setProperty(key, request.getParameter(key));
                }
            }

            String toSave = LibWIRIS.createIni(properties);
            String digest = storage.codeDigest(toSave);
            String url = request.getContextPath() + "/app/showimage?formula=" + URLEncoder.encode(digest, "UTF-8");
            String returnDigestParameter = request.getParameter("returnDigest");

            if (returnDigestParameter != null && !returnDigestParameter.equals("false")) {
                out.print(digest + ":" + url);
            } else {
                out.print(url);
            }
        } else {
            out.print("Error: no mathml has been sent.");
        }
        out.close();
    }
}
