package com.wiris.plugin.configuration;

import java.util.Properties;

public interface ConfigurationUpdater {
    /**
     * Initializes the configuration udpater system. This method is called before any call to other methods.
     */
    void init();
    
    /**
     * Updates the configuration table with the desired values. It is expected to
     * call {@link Properties.setProperty} to change the value of any property.
     * 
     * @param configuration The configuration table.
     */
    void updateConfiguration(Properties configuration);
}
