/*
 * Decompiled with CFR 0.152.
 */
package com.winfooz;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.winfooz.WinAnalytics;
import java.io.IOException;
import kotlin.Unit;
import okhttp3.Request;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AnalyticsEnqueueAdapter<T>
implements Call<T> {
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Call<T> call;
    private final String baseUrl;
    private final boolean logEvent;

    AnalyticsEnqueueAdapter(String baseUrl, Call<T> call, boolean logEvent) {
        this.call = call;
        this.baseUrl = baseUrl;
        this.logEvent = logEvent;
    }

    public void enqueue(final @NonNull Callback<T> callback) {
        this.call.enqueue(new Callback<T>(){

            public void onResponse(@NonNull Call<T> call, @NonNull Response<T> response) {
                if (AnalyticsEnqueueAdapter.this.logEvent) {
                    WinAnalytics.getInstance().initEventArguments(AnalyticsEnqueueAdapter.this.baseUrl, call.request().url().toString(), response, true, () -> AnalyticsEnqueueAdapter.this.response(callback, response));
                } else {
                    AnalyticsEnqueueAdapter.this.response(callback, response);
                }
            }

            public void onFailure(@NonNull Call<T> call, @NonNull Throwable t) {
                if (AnalyticsEnqueueAdapter.this.logEvent) {
                    WinAnalytics.getInstance().initEventArguments(AnalyticsEnqueueAdapter.this.baseUrl, call.request().url().toString(), null, true, () -> AnalyticsEnqueueAdapter.this.failure(callback, t));
                } else {
                    AnalyticsEnqueueAdapter.this.failure(callback, t);
                }
            }
        });
    }

    @NonNull
    public Response<T> execute() throws IOException {
        return this.call.execute();
    }

    public boolean isExecuted() {
        return this.call.isExecuted();
    }

    public void cancel() {
        this.call.cancel();
    }

    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @NonNull
    public Call<T> clone() {
        return this.call.clone();
    }

    @NonNull
    public Request request() {
        return this.call.request();
    }

    private Unit response(@NonNull Callback<T> callback, @NonNull Response<T> response) {
        if (this.logEvent) {
            if (response.isSuccessful()) {
                WinAnalytics.getInstance().logSuccess(this.baseUrl, this.call.request().url().toString());
            } else {
                WinAnalytics.getInstance().logFailure(this.baseUrl, this.call.request().url().toString());
            }
        }
        this.handler.post(() -> callback.onResponse(this.call, response));
        return Unit.INSTANCE;
    }

    private Unit failure(@NonNull Callback<T> callback, @NonNull Throwable t) {
        if (this.logEvent) {
            WinAnalytics.getInstance().logFailure(this.baseUrl, this.call.request().url().toString());
        }
        this.handler.post(() -> callback.onFailure(this.call, t));
        return Unit.INSTANCE;
    }
}

