/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.apache.http.entity.ContentType;

public class Notification {
    Map<String, String> headers = new HashMap<String, String>();
    String body;
    ContentType contentType;

    public static Notification createWindowsNotification(String body) {
        Notification n = new Notification();
        n.body = body;
        n.headers.put("ServiceBusNotification-Format", "windows");
        if (body.matches("\\s*<toast[\\s\\S]*>[\\s\\S]+</toast>$")) {
            n.headers.put("X-WNS-Type", "wns/toast");
        }
        if (body.matches("\\s*<tile[\\s\\S]*>[\\s\\S]+</tile>$")) {
            n.headers.put("X-WNS-Type", "wns/tile");
        }
        if (body.matches("\\s*<badge[\\s\\S]*>[\\s\\S]+</badge>$")) {
            n.headers.put("X-WNS-Type", "wns/badge");
        }
        if (body.startsWith("<")) {
            n.contentType = ContentType.APPLICATION_XML;
        }
        return n;
    }

    public static Notification createWindowsRawNotification(String body) {
        Notification n = new Notification();
        n.body = body;
        n.headers.put("ServiceBusNotification-Format", "windows");
        n.headers.put("X-WNS-Type", "wns/raw");
        n.contentType = ContentType.APPLICATION_OCTET_STREAM;
        return n;
    }

    @Deprecated
    public static Notification createAppleNotifiation(String body) {
        return Notification.createAppleNotification(body);
    }

    public static Notification createAppleNotification(String body) {
        Date now = new Date();
        Date tomorrow = new Date(now.getTime() + 86400000L);
        return Notification.createAppleNotification(body, tomorrow);
    }

    public static Notification createAppleNotification(String body, Map<String, String> headers) {
        Date now = new Date();
        Date tomorrow = new Date(now.getTime() + 86400000L);
        return Notification.createAppleNotification(body, tomorrow, headers);
    }

    public static Notification createAppleNotification(String body, Date expiry) {
        return Notification.createAppleNotification(body, expiry, null);
    }

    public static Notification createAppleNotification(String body, Date expiry, Map<String, String> headers) {
        Notification n = new Notification();
        n.body = body;
        n.contentType = ContentType.APPLICATION_JSON;
        n.headers.put("ServiceBusNotification-Format", "apple");
        if (expiry != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            String expiryString = formatter.format(expiry.getTime());
            n.headers.put("ServiceBusNotification-Apns-Expiry", expiryString);
        }
        if (headers != null) {
            n.headers = headers;
        }
        return n;
    }

    @Deprecated
    public static Notification createGcmNotifiation(String body) {
        return Notification.createGcmNotification(body);
    }

    @Deprecated
    public static Notification createGcmNotification(String body) {
        Notification n = new Notification();
        n.body = body;
        n.contentType = ContentType.APPLICATION_JSON;
        n.headers.put("ServiceBusNotification-Format", "gcm");
        return n;
    }

    @Deprecated
    public static Notification createFcmNotifiation(String body) {
        return Notification.createFcmNotification(body);
    }

    public static Notification createFcmNotification(String body) {
        Notification n = new Notification();
        n.body = body;
        n.contentType = ContentType.APPLICATION_JSON;
        n.headers.put("ServiceBusNotification-Format", "gcm");
        return n;
    }

    @Deprecated
    public static Notification createAdmNotifiation(String body) {
        return Notification.createAdmNotification(body);
    }

    public static Notification createAdmNotification(String body) {
        Notification n = new Notification();
        n.body = body;
        n.contentType = ContentType.APPLICATION_JSON;
        n.headers.put("ServiceBusNotification-Format", "adm");
        return n;
    }

    @Deprecated
    public static Notification createBaiduNotifiation(String body) {
        return Notification.createBaiduNotification(body);
    }

    public static Notification createBaiduNotification(String body) {
        Notification n = new Notification();
        n.body = body;
        n.contentType = ContentType.APPLICATION_JSON;
        n.headers.put("ServiceBusNotification-Format", "baidu");
        return n;
    }

    @Deprecated
    public static Notification createMpnsNotifiation(String body) {
        return Notification.createMpnsNotification(body);
    }

    public static Notification createMpnsNotification(String body) {
        Notification n = new Notification();
        n.body = body;
        n.headers.put("ServiceBusNotification-Format", "windowsphone");
        if (body.contains("<wp:Toast>")) {
            n.headers.put("X-WindowsPhone-Target", "toast");
            n.headers.put("X-NotificationClass", "2");
        }
        if (body.contains("<wp:Tile>")) {
            n.headers.put("X-WindowsPhone-Target", "tile");
            n.headers.put("X-NotificationClass", "1");
        }
        if (body.startsWith("<")) {
            n.contentType = ContentType.APPLICATION_XML;
        }
        return n;
    }

    public static Notification createTemplateNotification(Map<String, String> properties) {
        Notification n = new Notification();
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        Iterator<String> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            buf.append("\"").append(key).append("\":\"").append(properties.get(key)).append("\"");
            if (!iterator.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        n.body = buf.toString();
        n.contentType = ContentType.APPLICATION_JSON;
        n.headers.put("ServiceBusNotification-Format", "template");
        return n;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }
}

