/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.windowsazure.messaging.InstallationTemplate;
import com.windowsazure.messaging.NotificationPlatform;
import com.windowsazure.messaging.WnsSecondaryTile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;

public class Installation {
    private String installationId;
    private String userId;
    private NotificationPlatform platform;
    private String pushChannel;
    private boolean pushChannelExpired;
    private String expirationTime;
    private List<String> tags;
    private Map<String, InstallationTemplate> templates;
    private Map<String, WnsSecondaryTile> secondaryTiles;

    public Installation() {
        this(null);
    }

    public Installation(String installationId) {
        this(installationId, (String[])null);
    }

    public Installation(String installationId, String ... tags) {
        this(installationId, (NotificationPlatform)null, (String)null, tags);
    }

    public Installation(String installationId, NotificationPlatform platform, String pushChannel) {
        this(installationId, platform, pushChannel, (String[])null);
    }

    public Installation(String installationId, NotificationPlatform platform, String pushChannel, String ... tags) {
        Installation.validateNotificationPlatform(platform);
        this.installationId = installationId;
        this.platform = platform;
        this.pushChannel = pushChannel;
        if (tags != null) {
            for (String tag : tags) {
                this.addTag(tag);
            }
        }
    }

    private static void validateNotificationPlatform(NotificationPlatform notificationPlatform) {
        if (notificationPlatform == NotificationPlatform.Fcm) {
            throw new RuntimeException("FCM is currently not supported, use NotificationPlatform.Gcm which uses FCM Legacy Mode. See https://aka.ms/AA9dpaz");
        }
    }

    public String getInstallationId() {
        return this.installationId;
    }

    public void setInstallationId(String installationId) {
        this.installationId = installationId;
    }

    public String getPushChannel() {
        return this.pushChannel;
    }

    public void setPushChannel(String pushChannel) {
        this.pushChannel = pushChannel;
    }

    public boolean isPushChannelExpired() {
        return this.pushChannelExpired;
    }

    public Date getExpirationTime() {
        return DatatypeConverter.parseDateTime((String)this.expirationTime).getTime();
    }

    public void setExpirationTime(Date expirationTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
        this.expirationTime = formatter.format(expirationTime);
    }

    public NotificationPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(NotificationPlatform platform) {
        Installation.validateNotificationPlatform(platform);
        this.platform = platform;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(tag);
    }

    public void clearTags() {
        if (this.tags == null) {
            return;
        }
        this.tags.clear();
    }

    public Map<String, InstallationTemplate> getTemplates() {
        return this.templates;
    }

    public void addTemplate(String templateName, InstallationTemplate template) {
        if (this.templates == null) {
            this.templates = new HashMap<String, InstallationTemplate>();
        }
        this.templates.put(templateName, template);
    }

    public void removeTemplate(String templateName) {
        if (this.templates == null) {
            return;
        }
        this.templates.remove(templateName);
    }

    public void clearTemplates() {
        if (this.templates == null) {
            return;
        }
        this.templates.clear();
    }

    public Map<String, WnsSecondaryTile> getSecondaryTiles() {
        return this.secondaryTiles;
    }

    public void addSecondaryTile(String tileName, WnsSecondaryTile tile) {
        if (this.templates == null) {
            this.secondaryTiles = new HashMap<String, WnsSecondaryTile>();
        }
        this.secondaryTiles.put(tileName, tile);
    }

    public void removeSecondaryTile(String tileName) {
        if (this.templates == null) {
            return;
        }
        this.secondaryTiles.remove(tileName);
    }

    public void clearSecondaryTiles() {
        if (this.templates == null) {
            return;
        }
        this.secondaryTiles.clear();
    }

    public static Installation fromJson(String json) {
        return (Installation)new Gson().fromJson(json, Installation.class);
    }

    public static Installation fromJson(InputStream json) throws IOException {
        return Installation.fromJson(IOUtils.toString((InputStream)json, (Charset)StandardCharsets.UTF_8));
    }

    public String toJson() {
        return new GsonBuilder().disableHtmlEscaping().create().toJson((Object)this);
    }
}

