/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.widget.TextView;
import oak.R;
import oak.widget.TextViewWithFont;

public class GradientTextView
extends TextViewWithFont {
    private static final String TAG = GradientTextView.class.getSimpleName();
    private int[] mGradientColors;
    private float[] mGradientPositions;
    private float mGradientAngle = 0.0f;
    private LinearGradient mGradient;

    public GradientTextView(Context context) {
        this(context, null);
    }

    public GradientTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GradientTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray typedArray;
        if (attrs != null && (typedArray = context.obtainStyledAttributes(attrs, R.styleable.BeastTextView)) != null) {
            try {
                int gradientPositionsResId;
                int gradientColorsResId = typedArray.getResourceId(0, -1);
                if (gradientColorsResId != -1) {
                    String[] colors = context.getResources().getStringArray(gradientColorsResId);
                    this.mGradientColors = new int[colors.length];
                    for (int i = 0; i < colors.length; ++i) {
                        this.mGradientColors[i] = Color.parseColor((String)colors[i]);
                    }
                }
                if ((gradientPositionsResId = typedArray.getResourceId(1, -1)) != -1) {
                    String[] gps = context.getResources().getStringArray(gradientPositionsResId);
                    this.mGradientPositions = new float[gps.length];
                    for (int i = 0; i < gps.length; ++i) {
                        this.mGradientPositions[i] = Float.parseFloat(gps[i]);
                    }
                }
                this.mGradientAngle = typedArray.getFloat(2, 1.0f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            typedArray.recycle();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mGradient == null && this.mGradientColors != null && this.mGradientPositions != null) {
            this.mGradient = GradientTextView.getGradient(this.getMeasuredWidth(), this.getMeasuredHeight(), this.mGradientAngle, this.mGradientColors, this.mGradientPositions);
            this.getPaint().setShader((Shader)this.mGradient);
        }
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mGradient = null;
    }

    public static void setGradient(TextView tv, float angle, int[] colors, float[] positions) {
        tv.measure(tv.getLayoutParams().width, tv.getLayoutParams().height);
        LinearGradient gradient = GradientTextView.getGradient(tv.getMeasuredWidth(), tv.getMeasuredHeight(), angle, colors, positions);
        tv.getPaint().setShader((Shader)gradient);
    }

    static LinearGradient getGradient(int measuredWidth, int measuredHeight, float angle, int[] colors, float[] positions) {
        double n;
        double x;
        double y;
        double rad = Math.toRadians(angle);
        double oa = Math.tan(rad);
        if (oa == Double.POSITIVE_INFINITY) {
            y = 1.0;
            x = 0.0;
        } else if (oa == Double.NEGATIVE_INFINITY) {
            y = -1.0;
            x = 0.0;
        } else {
            y = oa;
            x = rad > Math.PI ? -1.0 : 1.0;
        }
        int mx = measuredWidth;
        int my = measuredHeight;
        int cx = mx / 2;
        int cy = my / 2;
        if (x == 0.0) {
            n = (double)cy / y;
        } else if (y == 0.0) {
            n = (double)cx / x;
        } else {
            n = (double)cy / y;
            double n2 = (double)cx / x;
            if (Math.abs(n2) < Math.abs(n)) {
                n = n2;
            }
        }
        int sx = (int)((double)cx - n * x);
        int sy = (int)((double)cy - n * y);
        int ex = (int)((double)cx + n * x);
        int ey = (int)((double)cy + n * y);
        return new LinearGradient((float)sx, (float)sy, (float)ex, (float)ey, colors, positions, Shader.TileMode.CLAMP);
    }
}

