/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import oak.util.RatioSizingUtils;

public class AspectRatioLayout
extends FrameLayout {
    private RatioSizingUtils.RatioSizingInfo mRatioSizingInfo = new RatioSizingUtils.RatioSizingInfo();

    public AspectRatioLayout(Context context) {
        super(context);
    }

    public AspectRatioLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AspectRatioLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mRatioSizingInfo = RatioSizingUtils.getRatioSizingInfoFromAttrs(context, attrs);
    }

    public void setAspectRatio(int width, int height) {
        this.mRatioSizingInfo.aspectRatioWidth = width;
        this.mRatioSizingInfo.aspectRatioHeight = height;
        this.requestLayout();
    }

    public void setAspectRatio(String ratioString) {
        this.mRatioSizingInfo = RatioSizingUtils.parseRatioSizingInfo(ratioString);
        this.requestLayout();
    }

    public long getAspectRatioWidth() {
        return this.mRatioSizingInfo.aspectRatioWidth;
    }

    public long getAspectRatioHeight() {
        return this.mRatioSizingInfo.aspectRatioHeight;
    }

    public float getAspectRatio() {
        return (float)this.mRatioSizingInfo.aspectRatioWidth / (float)this.mRatioSizingInfo.aspectRatioHeight;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        int heightPadding = this.getPaddingTop() + this.getPaddingBottom();
        RatioSizingUtils.RatioMeasureInfo rmi = RatioSizingUtils.getMeasureInfo(widthMeasureSpec, heightMeasureSpec, this.mRatioSizingInfo, widthPadding, heightPadding);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)(rmi.width + widthPadding), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(rmi.height + heightPadding), (int)0x40000000));
    }
}

