/*
 * Decompiled with CFR 0.152.
 */
package oak.util;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import oak.R;

public class RatioSizingUtils {
    public static RatioSizingInfo getRatioSizingInfoFromAttrs(Context context, AttributeSet attrs) throws IllegalArgumentException {
        RatioSizingInfo rsi = new RatioSizingInfo();
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AspectRatioLayout);
            String ratioString = a.getString(0);
            rsi = RatioSizingUtils.parseRatioSizingInfo(ratioString);
            a.recycle();
        }
        return rsi;
    }

    public static RatioSizingInfo parseRatioSizingInfo(String ratioString) throws IllegalArgumentException {
        RatioSizingInfo rsi = new RatioSizingInfo();
        if (TextUtils.isEmpty((CharSequence)ratioString)) {
            rsi.aspectRatioWidth = 1L;
            rsi.aspectRatioHeight = 1L;
            return rsi;
        }
        String[] parts = ratioString.split("[x:]");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid ratio: " + ratioString);
        }
        rsi.aspectRatioWidth = Integer.parseInt(parts[0]);
        rsi.aspectRatioHeight = Integer.parseInt(parts[1]);
        return rsi;
    }

    public static RatioMeasureInfo getMeasureInfo(int widthMeasureSpec, int heightMeasureSpec, RatioSizingInfo ratioSizingInfo, int widthPadding, int heightPadding) {
        RatioMeasureInfo rmi = new RatioMeasureInfo();
        rmi.width = View.MeasureSpec.getSize((int)widthMeasureSpec) - widthPadding;
        rmi.height = View.MeasureSpec.getSize((int)heightMeasureSpec) - heightPadding;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (rmi.height <= 0 && rmi.width <= 0 && heightMode == 0 && widthMode == 0) {
            rmi.width = 0;
            rmi.height = 0;
        } else if (rmi.height <= 0 && heightMode == 0) {
            rmi.height = (int)((long)rmi.width * ratioSizingInfo.aspectRatioHeight / ratioSizingInfo.aspectRatioWidth);
        } else if (rmi.width <= 0 && widthMode == 0) {
            rmi.width = (int)((long)rmi.height * ratioSizingInfo.aspectRatioWidth / ratioSizingInfo.aspectRatioHeight);
        } else if ((long)rmi.width * ratioSizingInfo.aspectRatioHeight > ratioSizingInfo.aspectRatioWidth * (long)rmi.height) {
            rmi.width = (int)((long)rmi.height * ratioSizingInfo.aspectRatioWidth / ratioSizingInfo.aspectRatioHeight);
        } else {
            rmi.height = (int)((long)rmi.width * ratioSizingInfo.aspectRatioHeight / ratioSizingInfo.aspectRatioWidth);
        }
        return rmi;
    }

    public static class RatioMeasureInfo {
        public int width;
        public int height;
    }

    public static class RatioSizingInfo {
        public long aspectRatioWidth = 1L;
        public long aspectRatioHeight = 1L;
    }
}

