/*
 * Decompiled with CFR 0.152.
 */
package oak.nfc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.os.Parcelable;
import android.util.Log;
import android.widget.TextView;
import android.widget.Toast;
import java.io.IOException;

public class TagWriter {
    private static final String TAG = "OakTagWriter";
    NfcAdapter adapter;
    PendingIntent nfcPendingIntent;
    private NdefMessage message;
    IntentFilter[] writeTagFilters;
    IntentFilter[] ndefExchangeFilters;
    private boolean writeMode = false;
    private Tag tag;
    private Activity activity;
    private String mimeType;
    private NdefMessage[] messages;
    private byte[] mPayload;
    private String payloadString;

    public TagWriter(Context context, String mimeType, Activity activity, PendingIntent pendingIntent, IntentFilter[] intentFilters) {
        this.ndefExchangeFilters = intentFilters;
        this.activity = activity;
        this.nfcPendingIntent = pendingIntent;
        this.adapter = NfcAdapter.getDefaultAdapter((Context)context);
        this.createMimeType(mimeType);
    }

    public void enableNdefExchangeMode() {
        this.adapter.setNdefPushMessage(this.message, this.activity, new Activity[0]);
        this.adapter.enableForegroundDispatch(this.activity, this.nfcPendingIntent, this.ndefExchangeFilters, (String[][])null);
    }

    public void disableNdefExchangeMode() {
        this.adapter.setNdefPushMessage(null, this.activity, new Activity[0]);
        this.adapter.disableForegroundDispatch(this.activity);
    }

    public NdefMessage getTextViewAsNdef(TextView view) {
        byte[] textBytes = view.getText().toString().getBytes();
        NdefRecord textRecord = new NdefRecord(2, this.mimeType.getBytes(), new byte[0], textBytes);
        this.message = new NdefMessage(new NdefRecord[]{textRecord});
        return this.message;
    }

    public void setPayloadString() {
        this.payloadString = new String(this.message.getRecords()[0].getPayload());
    }

    public String getPayloadString() {
        return this.payloadString;
    }

    public void clearPushMessage() {
        this.adapter.setNdefPushMessage(null, this.activity, new Activity[0]);
    }

    public byte[] getBytePayload() {
        this.mPayload = this.messages[0].getRecords()[0].getPayload();
        return this.mPayload;
    }

    public NdefMessage getNdefMessage() {
        return this.message;
    }

    public NdefMessage[] getNdefMessages() {
        return this.messages;
    }

    public NdefMessage getMessageFromArray() {
        this.message = this.messages[0];
        return this.message;
    }

    public NdefMessage[] getNdefMessages(Intent intent) {
        NdefMessage[] msgs = null;
        String action = intent.getAction();
        if ("android.nfc.action.TAG_DISCOVERED".equals(action) || "android.nfc.action.NDEF_DISCOVERED".equals(action)) {
            Parcelable[] rawMsgs = intent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES");
            if (rawMsgs != null) {
                msgs = new NdefMessage[rawMsgs.length];
                for (int i = 0; i < rawMsgs.length; ++i) {
                    msgs[i] = (NdefMessage)rawMsgs[i];
                }
                this.messages = msgs;
            } else {
                byte[] empty = new byte[]{};
                NdefRecord record = new NdefRecord(5, empty, empty, empty);
                NdefMessage msg = new NdefMessage(new NdefRecord[]{record});
                msgs = new NdefMessage[]{msg};
                this.messages = msgs;
            }
        } else {
            Log.d((String)TAG, (String)"Unknown intent.");
            this.activity.finish();
        }
        return this.messages;
    }

    public Tag getDetectedTag(Intent intent) {
        return (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
    }

    public boolean isWriteMode() {
        return this.writeMode;
    }

    public boolean isNdefDiscovered(Intent intent) {
        return "android.nfc.action.NDEF_DISCOVERED".equals(intent.getAction());
    }

    public boolean isTagDiscovered(Intent intent) {
        return "android.nfc.action.TAG_DISCOVERED".equals(intent.getAction());
    }

    public void enableTagWriteMode() {
        this.writeMode = true;
        IntentFilter tagDetected = new IntentFilter("android.nfc.action.TAG_DISCOVERED");
        this.writeTagFilters = new IntentFilter[]{tagDetected};
        this.adapter.enableForegroundDispatch(this.activity, this.nfcPendingIntent, this.writeTagFilters, (String[][])null);
    }

    public void disableTagWriteMode() {
        this.writeMode = false;
        this.adapter.disableForegroundDispatch(this.activity);
    }

    public void createMimeType(String name) {
        this.mimeType = "application/" + name;
    }

    public void setMessage(String str) {
        byte[] textBytes = str.getBytes();
        NdefRecord stringRecord = new NdefRecord(2, this.mimeType.getBytes(), new byte[0], textBytes);
        this.message = new NdefMessage(new NdefRecord[]{stringRecord});
    }

    public void setMessage(byte[] bytes) {
        NdefRecord byteRecord = new NdefRecord(2, this.mimeType.getBytes(), new byte[0], bytes);
        this.message = new NdefMessage(new NdefRecord[]{byteRecord});
    }

    public boolean writeToTag(NdefMessage aMessage, Tag tag) {
        if (aMessage != null) {
            this.message = aMessage;
        }
        int size = this.message.toByteArray().length;
        try {
            Ndef ndef = Ndef.get((Tag)tag);
            if (ndef != null) {
                ndef.connect();
                if (!ndef.isWritable()) {
                    this.toast("Tag is read only");
                    return false;
                }
                if (ndef.getMaxSize() < size) {
                    this.toast("Tag capacity is " + ndef.getMaxSize() + " bytes, message is " + size + " bytes.");
                    return false;
                }
                ndef.writeNdefMessage(this.message);
                this.toast("Wrote message to pre-formatted tag.");
                return true;
            }
            NdefFormatable format = NdefFormatable.get((Tag)tag);
            if (format != null) {
                try {
                    format.connect();
                    format.format(this.message);
                    this.toast("Formatted tag and wrote message");
                    return true;
                }
                catch (IOException e) {
                    this.toast("Failed to format tag");
                    return false;
                }
            }
            this.toast("Tag doesn't support NDEF.");
            return false;
        }
        catch (Exception e) {
            this.toast("Failed to write tag");
            return false;
        }
    }

    private void toast(String text) {
        Toast.makeText((Context)this.activity, (CharSequence)text, (int)0).show();
    }
}

