/*
 * Decompiled with CFR 0.152.
 */
package oak;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FlushedInputStream
extends BufferedInputStream {
    public FlushedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public long skip(long n) throws IOException {
        long totalBytesSkipped;
        long bytesSkipped;
        for (totalBytesSkipped = 0L; totalBytesSkipped < n; totalBytesSkipped += bytesSkipped) {
            bytesSkipped = this.in.skip(n - totalBytesSkipped);
            if (bytesSkipped != 0L) continue;
            int aByte = this.read();
            if (aByte < 0) break;
            bytesSkipped = 1L;
        }
        return totalBytesSkipped;
    }
}

