/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.FailingAssert;
import assertk.FailureKt;
import assertk.ValueAssert;
import assertk.assertions.AnyKt;
import assertk.assertions.MapKt;
import assertk.assertions.support.SupportKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\u001a=\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0007\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\b\u001a<\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n\u001a[\u0010\u000b\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042*\u0010\f\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n0\r\"\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\nH\u0007\u00a2\u0006\u0002\u0010\u000e\u001aY\u0010\u000f\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042*\u0010\f\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n0\r\"\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n\u00a2\u0006\u0002\u0010\u000e\u001aY\u0010\u0010\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042*\u0010\f\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n0\r\"\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n\u00a2\u0006\u0002\u0010\u000e\u001aY\u0010\u0011\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042*\u0010\f\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n0\r\"\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n\u00a2\u0006\u0002\u0010\u000e\u001a=\u0010\u0012\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0007\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\b\u001a<\u0010\u0012\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n\u001a5\u0010\u0013\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a(\u0010\u0015\u001a\u00020\u0001*\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u00042\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u001a \u0010\u0017\u001a\u00020\u0001*\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0018\u0010\u001a\u001a\u00020\u0001*\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u0004\u001a\u0018\u0010\u001b\u001a\u00020\u0001*\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u0004\u001a\u001a\u0010\u001c\u001a\u00020\u0001*\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00050\u0004\u001a;\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0004\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u001d\u001a\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004*\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u0004\u00a8\u0006\u001e"}, d2={"contains", "", "K", "V", "Lassertk/Assert;", "", "key", "value", "(Lassertk/Assert;Ljava/lang/Object;Ljava/lang/Object;)V", "element", "Lkotlin/Pair;", "containsAll", "elements", "", "(Lassertk/Assert;[Lkotlin/Pair;)V", "containsAtLeast", "containsNone", "containsOnly", "doesNotContain", "doesNotContainKey", "(Lassertk/Assert;Ljava/lang/Object;)V", "hasSameSizeAs", "other", "hasSize", "size", "", "isEmpty", "isNotEmpty", "isNullOrEmpty", "(Lassertk/Assert;Ljava/lang/Object;)Lassertk/Assert;", "assertk"})
@SourceDebugExtension(value={"SMAP\nmap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 map.kt\nassertk/assertions/MapKt\n+ 2 assert.kt\nassertk/Assert\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,176:1\n50#2,8:177\n50#2,8:185\n50#2,8:193\n50#2,8:201\n50#2,8:209\n50#2,3:217\n53#2,5:225\n50#2,8:230\n50#2,8:238\n50#2,3:246\n53#2,5:254\n50#2,3:259\n53#2,5:276\n26#2,10:281\n12271#3,2:220\n4117#3:222\n4217#3,2:223\n12271#3,2:249\n3792#3:251\n4307#3,2:252\n551#4:262\n536#4,6:263\n551#4:269\n536#4,6:270\n*S KotlinDebug\n*F\n+ 1 map.kt\nassertk/assertions/MapKt\n*L\n18#1:177,8\n27#1:185,8\n36#1:193,8\n51#1:201,8\n62#1:209,8\n90#1:217,3\n90#1:225,5\n103#1:230,8\n121#1:238,8\n130#1:246,3\n130#1:254,5\n144#1:259,3\n144#1:276,5\n169#1:281,10\n91#1:220,2\n95#1:222\n95#1:223,2\n131#1:249,2\n132#1:251\n132#1:252,2\n146#1:262\n146#1:263,6\n148#1:269\n148#1:270,6\n*E\n"})
public final class MapKt {
    @NotNull
    public static final Assert<Integer> size(@NotNull Assert<? extends Map<?, ?>> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return AnyKt.prop($this$size, "size", (Function1)size.1.INSTANCE);
    }

    public static final void isEmpty(@NotNull Assert<? extends Map<?, ?>> $this$isEmpty) {
        Intrinsics.checkNotNullParameter($this$isEmpty, (String)"<this>");
        Assert<? extends Map<?, ?>> this_$iv = $this$isEmpty;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Map actual = (Map)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.isEmpty()) {
                    return;
                }
                SupportKt.expected$default($this$isEmpty, "to be empty but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isNotEmpty(@NotNull Assert<? extends Map<?, ?>> $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter($this$isNotEmpty, (String)"<this>");
        Assert<? extends Map<?, ?>> this_$iv = $this$isNotEmpty;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Map actual = (Map)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!actual.isEmpty()) {
                    return;
                }
                SupportKt.expected$default($this$isNotEmpty, "to not be empty", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isNullOrEmpty(@NotNull Assert<? extends Map<?, ?>> $this$isNullOrEmpty) {
        Intrinsics.checkNotNullParameter($this$isNullOrEmpty, (String)"<this>");
        Assert<? extends Map<?, ?>> this_$iv = $this$isNullOrEmpty;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Map actual = (Map)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual == null || actual.isEmpty()) {
                    return;
                }
                SupportKt.expected$default($this$isNullOrEmpty, "to be null or empty but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void hasSize(@NotNull Assert<? extends Map<?, ?>> $this$hasSize, int size2) {
        Intrinsics.checkNotNullParameter($this$hasSize, (String)"<this>");
        AnyKt.isEqualTo(MapKt.size($this$hasSize), size2);
    }

    public static final void hasSameSizeAs(@NotNull Assert<? extends Map<?, ?>> $this$hasSameSizeAs, @NotNull Map<?, ?> other) {
        Intrinsics.checkNotNullParameter($this$hasSameSizeAs, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Assert<? extends Map<?, ?>> this_$iv = $this$hasSameSizeAs;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Map actual = (Map)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                int actualSize = actual.size();
                int otherSize = other.size();
                if (actualSize == otherSize) {
                    return;
                }
                SupportKt.expected$default($this$hasSameSizeAs, "to have same size as:" + SupportKt.show$default(other, null, 2, null) + " (" + otherSize + ") but was size:(" + actualSize + ')', null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <K, V> void contains(@NotNull Assert<? extends Map<K, ? extends V>> $this$contains, K key, V value) {
        Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
        Assert<? extends Map<K, ? extends V>> this_$iv = $this$contains;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Map actual = (Map)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.containsKey(key) && Intrinsics.areEqual(actual.get(key), value)) {
                    return;
                }
                SupportKt.expected$default($this$contains, "to contain:" + SupportKt.show$default(MapsKt.mapOf((Pair)TuplesKt.to(key, value)), null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <K, V> void contains(@NotNull Assert<? extends Map<K, ? extends V>> $this$contains, @NotNull Pair<? extends K, ? extends V> element) {
        Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        MapKt.contains($this$contains, element.getFirst(), element.getSecond());
    }

    @Deprecated(message="renamed to containsAtLeast", replaceWith=@ReplaceWith(expression="containsAtLeast(*elements)", imports={}))
    public static final <K, V> void containsAll(@NotNull Assert<? extends Map<K, ? extends V>> $this$containsAll, Pair<? extends K, ? extends V> ... elements) {
        Intrinsics.checkNotNullParameter($this$containsAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        MapKt.containsAtLeast($this$containsAll, Arrays.copyOf(elements, elements.length));
    }

    /*
     * WARNING - void declaration
     */
    public static final <K, V> void containsAtLeast(@NotNull Assert<? extends Map<K, ? extends V>> $this$containsAtLeast, Pair<? extends K, ? extends V> ... elements) {
        Intrinsics.checkNotNullParameter($this$containsAtLeast, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Assert<? extends Map<K, ? extends V>> this_$iv = $this$containsAtLeast;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                void $this$filterNotTo$iv$iv;
                boolean bl;
                Map actual;
                block6: {
                    actual = (Map)((ValueAssert)this_$iv).getValue();
                    boolean bl2 = false;
                    Pair<? extends K, ? extends V>[] $this$all$iv = elements;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Pair<? extends K, ? extends V> element$iv;
                        Pair<? extends K, ? extends V> pair = element$iv = $this$all$iv[i];
                        boolean bl3 = false;
                        Object k = pair.component1();
                        Object v = pair.component2();
                        if (actual.containsKey(k) && Intrinsics.areEqual(actual.get(k), (Object)v)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (bl) {
                    return;
                }
                Pair<? extends K, ? extends V>[] $this$filterNot$iv = elements;
                boolean $i$f$filterNot = false;
                Pair<? extends K, ? extends V>[] pairArray = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                int n = ((void)$this$filterNotTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void var15_19 = element$iv$iv = $this$filterNotTo$iv$iv[i];
                    boolean bl4 = false;
                    Object k = var15_19.component1();
                    Object v = var15_19.component2();
                    if (actual.containsKey(k) && Intrinsics.areEqual(actual.get(k), (Object)v)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List notFound = (List)destination$iv$iv;
                SupportKt.expected$default($this$containsAtLeast, "to contain all:" + SupportKt.show$default(MapsKt.toMap(elements), null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null) + "\n elements not found:" + SupportKt.show$default(MapsKt.toMap((Iterable)notFound), null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <K, V> void doesNotContain(@NotNull Assert<? extends Map<K, ? extends V>> $this$doesNotContain, K key, V value) {
        Intrinsics.checkNotNullParameter($this$doesNotContain, (String)"<this>");
        Assert<? extends Map<K, ? extends V>> this_$iv = $this$doesNotContain;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Map actual = (Map)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!actual.containsKey(key) || !Intrinsics.areEqual(actual.get(key), value)) {
                    return;
                }
                SupportKt.expected$default($this$doesNotContain, "to not contain:" + SupportKt.show$default(MapsKt.mapOf((Pair)TuplesKt.to(key, value)), null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <K, V> void doesNotContain(@NotNull Assert<? extends Map<K, ? extends V>> $this$doesNotContain, @NotNull Pair<? extends K, ? extends V> element) {
        Intrinsics.checkNotNullParameter($this$doesNotContain, (String)"<this>");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        MapKt.doesNotContain($this$doesNotContain, element.getFirst(), element.getSecond());
    }

    public static final <K, V> void doesNotContainKey(@NotNull Assert<? extends Map<K, ? extends V>> $this$doesNotContainKey, K key) {
        Intrinsics.checkNotNullParameter($this$doesNotContainKey, (String)"<this>");
        Assert<? extends Map<K, ? extends V>> this_$iv = $this$doesNotContainKey;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Map it = (Map)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!it.containsKey(key)) {
                    return;
                }
                SupportKt.expected$default($this$doesNotContainKey, "to not contain key:" + SupportKt.show$default(key, null, 2, null) + " but had value: " + SupportKt.show$default(it.get(key), null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <K, V> void containsNone(@NotNull Assert<? extends Map<K, ? extends V>> $this$containsNone, Pair<? extends K, ? extends V> ... elements) {
        Intrinsics.checkNotNullParameter($this$containsNone, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Assert<? extends Map<K, ? extends V>> this_$iv = $this$containsNone;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                void $this$filterTo$iv$iv;
                boolean bl;
                Map actual;
                block6: {
                    actual = (Map)((ValueAssert)this_$iv).getValue();
                    boolean bl2 = false;
                    Pair<? extends K, ? extends V>[] $this$all$iv = elements;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Pair<? extends K, ? extends V> element$iv;
                        Pair<? extends K, ? extends V> pair = element$iv = $this$all$iv[i];
                        boolean bl3 = false;
                        Object k = pair.component1();
                        Object v = pair.component2();
                        if (!actual.containsKey(k) || !Intrinsics.areEqual(actual.get(k), (Object)v)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (bl) {
                    return;
                }
                Pair<? extends K, ? extends V>[] $this$filter$iv = elements;
                boolean $i$f$filter = false;
                Pair<? extends K, ? extends V>[] pairArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void var15_19 = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl4 = false;
                    Object k = var15_19.component1();
                    Object v = var15_19.component2();
                    if (!Intrinsics.areEqual(actual.get(k), (Object)v)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List notExpected = (List)destination$iv$iv;
                SupportKt.expected$default($this$containsNone, "to contain none of:" + SupportKt.show$default(MapsKt.toMap(elements), null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null) + "\n elements not expected:" + SupportKt.show$default(MapsKt.toMap((Iterable)notExpected), null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <K, V> void containsOnly(@NotNull Assert<? extends Map<K, ? extends V>> $this$containsOnly, Pair<? extends K, ? extends V> ... elements) {
        Intrinsics.checkNotNullParameter($this$containsOnly, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Assert<? extends Map<K, ? extends V>> this_$iv = $this$containsOnly;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                void $this$containsOnly_u24lambda_u2416_u24lambda_u2415;
                StringBuilder stringBuilder;
                StringBuilder $this$filterNotTo$iv$iv;
                void $this$filterNotTo$iv$iv2;
                Map elementMap;
                Map actual = (Map)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                Map $this$filterNot$iv = elementMap = MapsKt.toMap(elements);
                boolean $i$f$filterNot = false;
                Map map = $this$filterNot$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterNotTo = false;
                Iterator iterator = $this$filterNotTo$iv$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry entry = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (actual.containsKey(key) && Intrinsics.areEqual(actual.get(key), value)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map notInActual = destination$iv$iv;
                Map $this$filterNot$iv2 = actual;
                boolean $i$f$filterNot2 = false;
                destination$iv$iv = $this$filterNot$iv2;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$filterNotTo2 = false;
                Iterator iterator2 = $this$filterNotTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry entry = element$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (elementMap.containsKey(key) && Intrinsics.areEqual(elementMap.get(key), value)) continue;
                    destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map notInExpected = destination$iv$iv2;
                if (notInActual.isEmpty() && notInExpected.isEmpty()) {
                    return;
                }
                $this$filterNotTo$iv$iv = stringBuilder = new StringBuilder("to contain only:" + SupportKt.show$default(elementMap, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null));
                Assert<? extends Map<K, ? extends V>> assert_ = $this$containsOnly;
                boolean bl4 = false;
                if (!notInActual.isEmpty()) {
                    $this$containsOnly_u24lambda_u2416_u24lambda_u2415.append("\n elements not found:" + SupportKt.show$default(notInActual, null, 2, null));
                }
                if (!notInExpected.isEmpty()) {
                    $this$containsOnly_u24lambda_u2416_u24lambda_u2415.append("\n extra elements found:" + SupportKt.show$default(notInExpected, null, 2, null));
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                SupportKt.expected$default(assert_, string, null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Assert<V> key(@NotNull Assert<? extends Map<K, ? extends V>> $this$key, K key) {
        Assert assert_;
        void this_$iv;
        Intrinsics.checkNotNullParameter($this$key, (String)"<this>");
        Assert<? extends Map<K, ? extends V>> assert_2 = $this$key;
        String name$iv = SupportKt.appendName$default($this$key, SupportKt.show(key, "[]"), null, 2, null);
        boolean $i$f$transform = false;
        void var5_5 = this_$iv;
        if (var5_5 instanceof ValueAssert) {
            Assert<Object> assert_3;
            try {
                void actual;
                Map map = (Map)((ValueAssert)this_$iv).getValue();
                void var9_8 = this_$iv;
                boolean bl = false;
                if (!actual.containsKey(key)) {
                    SupportKt.expected$default($this$key, "to have key:" + SupportKt.show$default(key, null, 2, null), null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                assert_3 = var9_8.assertThat(MapsKt.getValue((Map)actual, key), name$iv);
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
                assert_3 = this_$iv.failing(e$iv, name$iv);
            }
            assert_ = assert_3;
        } else if (var5_5 instanceof FailingAssert) {
            assert_ = this_$iv.failing(((FailingAssert)this_$iv).getError(), name$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return assert_;
    }
}

