/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.interfaces;

import android.util.Log;
import com.willblaschko.android.alexa.callbacks.AsyncCallback;
import com.willblaschko.android.alexa.connection.ClientUtil;
import com.willblaschko.android.alexa.interfaces.AvsException;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.response.ResponseParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public abstract class SendEvent {
    private static final String TAG = "SendEvent";
    protected ByteArrayOutputStream mOutputStream = new ByteArrayOutputStream();
    protected AsyncCallback<Void, Exception> mCallback;
    private Call currentCall;
    Request.Builder mRequestBuilder = new Request.Builder();
    MultipartBody.Builder mBodyBuilder;

    protected void prepareConnection(String url, String accessToken) {
        this.mRequestBuilder.url(url);
        this.mRequestBuilder.addHeader("Authorization", "Bearer " + accessToken);
        this.mBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("metadata", "metadata", RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=UTF-8"), (String)this.getEvent()));
        this.mOutputStream = new ByteArrayOutputStream();
    }

    protected AvsResponse completePost() throws IOException, AvsException, RuntimeException {
        this.addFormDataParts(this.mBodyBuilder);
        this.mRequestBuilder.post((RequestBody)this.mBodyBuilder.build());
        return this.parseResponse();
    }

    protected AvsResponse completeGet() throws IOException, AvsException, RuntimeException {
        this.mRequestBuilder.get();
        return this.parseResponse();
    }

    protected void cancelCall() {
        if (this.currentCall != null && !this.currentCall.isCanceled()) {
            this.currentCall.cancel();
        }
    }

    private AvsResponse parseResponse() throws IOException, AvsException, RuntimeException {
        Request request = this.mRequestBuilder.build();
        this.currentCall = ClientUtil.getTLS12OkHttpClient().newCall(request);
        try {
            Response response = this.currentCall.execute();
            if (response.code() == 204) {
                Log.w((String)TAG, (String)"Received a 204 response code from Amazon, is this expected?");
            }
            AvsResponse val = response.code() == 204 ? new AvsResponse() : ResponseParser.parseResponse(response.body().byteStream(), this.getBoundary(response));
            response.body().close();
            return val;
        }
        catch (IOException exp) {
            if (!this.currentCall.isCanceled()) {
                return new AvsResponse();
            }
            return null;
        }
    }

    protected String getBoundary(Response response) throws IOException {
        Headers headers = response.headers();
        String header = headers.get("content-type");
        String boundary = "";
        if (header != null) {
            Pattern pattern = Pattern.compile("boundary=(.*?);");
            Matcher matcher = pattern.matcher(header);
            if (matcher.find()) {
                boundary = matcher.group(1);
            }
        } else {
            Log.i((String)TAG, (String)("Body: " + response.body().string()));
        }
        return boundary;
    }

    protected void addFormDataParts(MultipartBody.Builder builder) {
    }

    @NotNull
    protected abstract String getEvent();
}

