/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.interactive;

import android.os.Bundle;
import com.amazon.identity.auth.device.ResponseManager;
import com.amazon.identity.auth.device.api.workflow.RequestContext;
import com.amazon.identity.auth.device.interactive.InteractiveRequestMap;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.interactive.InteractiveState;
import com.amazon.identity.auth.device.interactive.InteractiveStateFragment;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GenericInteractiveState
implements InteractiveState {
    private static final String LOG_TAG = GenericInteractiveState.class.getName();
    static final String SAVED_INSTANCE_STATE_KEY = InteractiveState.class.getName() + ".instanceState";
    static final String INTERACTIVE_STATE_ID_KEY = "interactiveStateId";
    static final String REQUEST_LIST_KEY = "requestRecords";
    private final InteractiveRequestMap interactiveRequestMap;
    private final ResponseManager responseManager;
    private final Set<InteractiveRequestRecord> requests;
    private WeakReference<InteractiveStateFragment> backingFragment;
    private UUID stateId;

    GenericInteractiveState(InteractiveStateFragment backingFragment) {
        this(backingFragment, ResponseManager.getInstance(), InteractiveRequestMap.getInstance());
    }

    GenericInteractiveState(InteractiveStateFragment backingFragment, ResponseManager responseManager, InteractiveRequestMap interactiveRequestMap) {
        this.backingFragment = new WeakReference<InteractiveStateFragment>(backingFragment);
        this.responseManager = responseManager;
        this.interactiveRequestMap = interactiveRequestMap;
        this.requests = new HashSet<InteractiveRequestRecord>();
        this.stateId = UUID.randomUUID();
    }

    String getId() {
        return this.stateId.toString();
    }

    Set<InteractiveRequestRecord> getRequests() {
        return this.requests;
    }

    @Override
    public synchronized void onRequestStart(InteractiveRequestRecord requestRecord) {
        String sourceType = requestRecord.getFragmentWrapper() == null ? "activity" : "fragment";
        MAPLog.d(LOG_TAG, "InteractiveState " + this.stateId + ": Recording " + sourceType + " request " + requestRecord.getRequestId());
        this.requests.add(requestRecord);
    }

    public boolean shouldAttemptProcessingResponses() {
        boolean hasOutgoingRequests = this.requests.size() > 0;
        boolean hasPendingResponses = this.responseManager.size() > 0;
        return hasOutgoingRequests && hasPendingResponses;
    }

    @Override
    public synchronized void processPendingResponses(RequestContext targetRequestContext) {
        if (this.shouldAttemptProcessingResponses()) {
            this.doProcessPendingResponses(targetRequestContext);
        } else {
            MAPLog.d(LOG_TAG, "InteractiveState " + this.stateId + ": No responses to process");
        }
    }

    void doProcessPendingResponses(RequestContext targetRequestContext) {
        LinkedList<InteractiveRequestRecord> requestsToRemove = new LinkedList<InteractiveRequestRecord>();
        for (InteractiveRequestRecord request : this.requests) {
            RequestContext requestContext;
            String requestId = request.getRequestId();
            if (!this.responseManager.hasPendingResponseForRequest(requestId) || (requestContext = this.getRequestContextForRequest(request)) != targetRequestContext) continue;
            MAPLog.d(LOG_TAG, "InteractiveState " + this.stateId + ": Processing request " + requestId);
            requestContext.processResponse(request, this.responseManager.removePendingResponse(requestId));
            requestsToRemove.add(request);
        }
        this.requests.removeAll(requestsToRemove);
    }

    RequestContext getRequestContextForRequest(InteractiveRequestRecord request) {
        Object requestSource = this.getRequestSourceForRequest(request);
        return this.interactiveRequestMap.getRequestContextForSource(requestSource);
    }

    Object getRequestSourceForRequest(InteractiveRequestRecord request) {
        Object requestSource = null;
        Bundle fragmentWrapper = request.getFragmentWrapper();
        if (fragmentWrapper != null) {
            requestSource = ((InteractiveStateFragment)this.backingFragment.get()).getFragment(fragmentWrapper);
        }
        if (requestSource == null) {
            requestSource = ((InteractiveStateFragment)this.backingFragment.get()).getParentActivity();
        }
        return requestSource;
    }

    public void readFromBundle(Bundle savedInstanceState) {
        Bundle stateBundle;
        if (savedInstanceState != null && (stateBundle = savedInstanceState.getBundle(SAVED_INSTANCE_STATE_KEY)) != null) {
            MAPLog.d(LOG_TAG, "Restoring interactive state from saved instance state");
            String savedUUID = stateBundle.getString(INTERACTIVE_STATE_ID_KEY);
            if (savedUUID == null) {
                MAPLog.w(LOG_TAG, "Restoring interactive state from instance state but no state ID found");
            } else {
                MAPLog.d(LOG_TAG, "Reassigning interactive state " + this.stateId + " to " + savedUUID);
                this.stateId = UUID.fromString(savedUUID);
            }
            ArrayList savedRequests = stateBundle.getParcelableArrayList(REQUEST_LIST_KEY);
            if (savedRequests != null) {
                this.requests.addAll(savedRequests);
            }
        }
    }

    public void writeToBundle(Bundle outState) {
        if (this.requests.size() > 0) {
            Bundle stateBundle = new Bundle();
            stateBundle.putString(INTERACTIVE_STATE_ID_KEY, this.stateId.toString());
            stateBundle.putParcelableArrayList(REQUEST_LIST_KEY, new ArrayList<InteractiveRequestRecord>(this.requests));
            outState.putBundle(SAVED_INSTANCE_STATE_KEY, stateBundle);
            MAPLog.d(LOG_TAG, "InteractiveState " + this.stateId + ": writing to save instance state");
        }
    }
}

