/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractPandaRequest;
import com.amazon.identity.auth.device.endpoint.PandaResponse;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJsonPandaRequest<T extends PandaResponse>
extends AbstractPandaRequest<T> {
    private static final String APPLICATION_JSON_CONTENT_TYPE = "application/json";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";

    public AbstractJsonPandaRequest(Context context, AppInfo appInfo) {
        super(context, appInfo);
    }

    @Override
    protected void setEntity() throws UnsupportedEncodingException, AuthError {
        StringEntity stringEntity = new StringEntity(this.getJsonString(), "UTF-8");
        ((HttpPost)this.httpRequest).setEntity((HttpEntity)stringEntity);
    }

    @Override
    protected List<Header> getExtraHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader(CONTENT_TYPE_HEADER, APPLICATION_JSON_CONTENT_TYPE));
        return headers;
    }

    private String getJsonString() throws AuthError {
        JSONObject json = new JSONObject();
        try {
            for (NameValuePair param : this.postParameters) {
                json.put(param.getName(), (Object)param.getValue());
            }
            return json.toString();
        }
        catch (JSONException e) {
            throw new AuthError("Received JSONException while building request", e, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
    }
}

