/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.RequestManager;
import com.amazon.identity.auth.device.StoredPreferences;
import com.amazon.identity.auth.device.api.authorization.AuthorizationManager;
import com.amazon.identity.auth.device.api.authorization.AuthorizeRequest;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.AuthorizationHelper;
import com.amazon.identity.auth.device.authorization.AuthorizationRequest;
import com.amazon.identity.auth.device.authorization.CodeChallengeWorkflow;
import com.amazon.identity.auth.device.authorization.ThirdPartyServiceHelper;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.RequestedScope;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.datastore.ProfileDataSource;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.device.utils.LWAConstants;
import com.amazon.identity.auth.device.utils.LWAServiceWrapper;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.List;

public class ThirdPartyAuthorizationHelper
extends AuthorizationHelper {
    private static final String CODE_KEY = "code";
    private static final String SCOPE_DATA_KEY = "scope_data";
    private static final String LOG_TAG = ThirdPartyAuthorizationHelper.class.getName();
    private static final String CLIENT_ID_PARAM_NAME = "client_id";
    private ThirdPartyServiceHelper mThirdPartyServiceHelper;
    private CodeChallengeWorkflow codeChallengeWorkflow = CodeChallengeWorkflow.getInstance();

    public ThirdPartyAuthorizationHelper() {
        this(new ThirdPartyServiceHelper());
    }

    public ThirdPartyAuthorizationHelper(ThirdPartyServiceHelper thirdPartyServiceHelper) {
        this.mThirdPartyServiceHelper = thirdPartyServiceHelper;
    }

    public void authorize(Context context, String packageName, String clientId, String redirectURI, String[] requestedScopes, boolean isBrowserFlow, TokenVendor tokenVendor, AuthorizationListener listener) throws AuthError {
        this.authorize(null, context, packageName, clientId, redirectURI, requestedScopes, isBrowserFlow, tokenVendor, listener, Bundle.EMPTY);
    }

    public void authorize(Context context, String packageName, String clientId, String redirectURI, String[] requestedScopes, boolean isBrowserFlow, TokenVendor tokenVendor, AuthorizationListener listener, Bundle options) throws AuthError {
        this.authorize(null, context, packageName, clientId, redirectURI, requestedScopes, isBrowserFlow, tokenVendor, listener, options);
    }

    public void authorize(final AuthorizeRequest originalRequest, final Context context, String packageName, final String clientId, String redirectURI, String[] requestedScopes, final boolean isBrowserFlow, TokenVendor tokenVendor, final AuthorizationListener listener, Bundle options) throws AuthError {
        if (ThreadUtils.isRunningOnMainThread()) {
            MAPLog.e(LOG_TAG, "authorize started on main thread");
            throw new IllegalStateException("authorize started on main thread");
        }
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        final AppInfo appInfo = appIdentifier.getAppInfo(packageName, context);
        List<RequestedScope> cachedScopes = tokenVendor.getCachedScopes(context);
        final String[] allScopes = ThirdPartyAuthorizationHelper.getCommonScopesForAuthorization(context, requestedScopes, cachedScopes);
        final boolean isSandboxMode = options.getBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, false);
        final Bundle extraParameters = options == Bundle.EMPTY ? new Bundle() : options;
        extraParameters.putBoolean(AuthzConstants.BUNDLE_KEY.CHECK_API_KEY.val, false);
        extraParameters.putBoolean(AuthzConstants.BUNDLE_KEY.RETURN_CODE.val, true);
        extraParameters.putString(LWAConstants.AUTHORIZE_BUNDLE_KEY.REGION.val, AuthorizationManager.getRegion(context).getStringValue());
        extraParameters.putString(AuthzConstants.BUNDLE_KEY.CLIENT_ID.val, clientId);
        extraParameters.putString(AuthzConstants.BUNDLE_KEY.SDK_VERSION.val, "LWAAndroidSDK3.0.0");
        try {
            extraParameters.putBundle(AuthzConstants.BUNDLE_KEY.EXTRA_URL_PARAMS.val, this.getExtraUrlParams(extraParameters));
        }
        catch (AuthError e) {
            listener.onError(e);
            return;
        }
        Bundle results = Bundle.EMPTY;
        if (!isSandboxMode && (StoredPreferences.isTokenObtainedFromSSO(context) || cachedScopes == null || cachedScopes.size() == 0)) {
            results = this.startAuthorizationWithService(context, allScopes, extraParameters);
        }
        if (results.containsKey(CODE_KEY) && !TextUtils.isEmpty((CharSequence)results.getString(CODE_KEY))) {
            if (extraParameters.getBoolean(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val, false)) {
                AuthorizationHelper.sendAuthorizationCodeAsResponse(results.getString(CODE_KEY), clientId, redirectURI, listener);
                return;
            }
            String codeVerifier = this.codeChallengeWorkflow.getCodeVerifier();
            this.handleCodeForTokenExchange(context, packageName, codeVerifier, results, extraParameters, listener);
            StoredPreferences.setTokenObtainedFromSSO(context, true);
        } else if (!(results.containsKey("AUTH_ERROR_EXECEPTION") || results.containsKey(AuthzConstants.BUNDLE_KEY.AUTHORIZE.val) || results.containsKey(AuthzConstants.BUNDLE_KEY.CAUSE_ID.val))) {
            ProfileDataSource.getInstance(context).deleteAllRows();
            Handler myHandler = new Handler(Looper.getMainLooper());
            myHandler.post(new Runnable(){

                public void run() {
                    try {
                        if (isBrowserFlow || isSandboxMode) {
                            ThirdPartyAuthorizationHelper.this.authorizeWithBrowser(originalRequest, context, context.getPackageName(), clientId, allScopes, listener, extraParameters, appInfo);
                            StoredPreferences.setTokenObtainedFromSSO(context, false);
                        } else {
                            listener.onError(new AuthError("WebView is not allowed for Authorization", AuthError.ERROR_TYPE.ERROR_BAD_PARAM));
                        }
                    }
                    catch (AuthError e) {
                        listener.onError(e);
                    }
                }
            });
        } else {
            results.setClassLoader(context.getClassLoader());
            if (results.containsKey(AuthzConstants.BUNDLE_KEY.CAUSE_ID.val)) {
                listener.onCancel(results);
            } else if (results.containsKey("AUTH_ERROR_EXECEPTION")) {
                listener.onError(AuthError.extractError(results));
            } else {
                DatabaseHelper.clearAuthorizationState(context);
                Bundle bundle = new Bundle();
                bundle.putString(AuthzConstants.BUNDLE_KEY.AUTHORIZE.val, "authorized via service");
                listener.onSuccess(bundle);
            }
        }
    }

    private void handleCodeForTokenExchange(Context context, String packageName, String codeVerifier, Bundle results, Bundle options, final AuthorizationListener listener) {
        this.doCodeForTokenExchange(context, packageName, codeVerifier, results, false, null, new TokenVendor(), new ThirdPartyAppIdentifier(), options, new AuthorizationListener(){

            public void onSuccess(Bundle response) {
                MAPLog.i(LOG_TAG, "Code for Token Exchange success");
                if (listener != null) {
                    listener.onSuccess(response);
                }
            }

            public void onError(AuthError e) {
                MAPLog.e(LOG_TAG, "Code for Token Exchange Error. " + e.getMessage());
                if (listener != null) {
                    listener.onError(e);
                }
            }

            public void onCancel(Bundle cause) {
                MAPLog.w(LOG_TAG, "Code for Token Exchange Cancel");
                if (listener != null) {
                    listener.onCancel(cause);
                }
            }
        });
    }

    private Bundle startAuthorizationWithService(Context context, final String[] scopes, final Bundle options) throws AuthError {
        Bundle result = (Bundle)new LWAServiceWrapper<Bundle>(){

            @Override
            protected Bundle doWork(Context workContext, AmazonAuthorizationServiceInterface service) throws AuthError, RemoteException {
                return ThirdPartyAuthorizationHelper.authorizeWithService(workContext, scopes, service, options);
            }
        }.execute(context, this.mThirdPartyServiceHelper);
        return result != null ? result : new Bundle();
    }

    private static Bundle authorizeWithService(Context context, String[] scopes, AmazonAuthorizationServiceInterface service, Bundle options) throws AuthError, RemoteException {
        Bundle result = service.authorize(options, context.getPackageName(), scopes);
        if (result != null) {
            result.setClassLoader(context.getClassLoader());
        }
        return result;
    }

    private void authorizeWithBrowser(AuthorizeRequest originalRequest, Context context, String packageName, String clientId, String[] scopes, AuthorizationListener listener, Bundle options, AppInfo appInfo) throws AuthError {
        options.getBundle(AuthzConstants.BUNDLE_KEY.EXTRA_URL_PARAMS.val).remove(CLIENT_ID_PARAM_NAME);
        AuthorizationRequest request = new AuthorizationRequest(originalRequest, clientId, scopes, options, appInfo, listener);
        RequestManager.getInstance().executeRequest(request, context);
    }

    private Bundle getExtraUrlParams(Bundle options) throws AuthError {
        Bundle extraUrlParams;
        if (options.getBoolean(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val, false)) {
            String codeChallenge = options.getString(AuthzConstants.BUNDLE_KEY.CODE_CHALLENGE.val);
            String codeChallengeMethod = options.getString(AuthzConstants.BUNDLE_KEY.CODE_CHALLENGE_METHOD.val);
            if (TextUtils.isEmpty((CharSequence)codeChallenge)) {
                throw new AuthError("Must provide code challenge parameter.", AuthError.ERROR_TYPE.ERROR_MISSING_CODE_CHALLENGE);
            }
            extraUrlParams = new Bundle();
            extraUrlParams.putString("code_challenge", codeChallenge);
            extraUrlParams.putString("code_challenge_method", codeChallengeMethod);
        } else {
            extraUrlParams = this.codeChallengeWorkflow.getProofKeyParameters();
        }
        if (options.getString(AuthzConstants.BUNDLE_KEY.SCOPE_DATA.val) != null) {
            extraUrlParams.putString(SCOPE_DATA_KEY, options.getString(AuthzConstants.BUNDLE_KEY.SCOPE_DATA.val));
        }
        extraUrlParams.putString(CLIENT_ID_PARAM_NAME, options.getString(AuthzConstants.BUNDLE_KEY.CLIENT_ID.val));
        return extraUrlParams;
    }
}

