/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.ScopesHelper;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.endpoint.ResponseUri;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthorizationResponseParser {
    private static final String LOG_TAG = AuthorizationResponseParser.class.getName();
    public static final String CLIENT_REQUEST_ID_STATE = "clientRequestId";
    public static final String REDIRECT_URI_STATE = "redirectUri";
    public static final String CLIENT_ID_STATE = "clientId";
    public static final String SCOPE = "scope";
    public static final String CODE = "code";
    public static final String RESPONSE_URL = "responseUrl";
    public static final String ERROR = "error";
    public static final String ERROR_DESCRIPTION = "error_description";
    public static final String ERROR_ACCESS_DENIED = "access_denied";
    public static final String ERROR_INVALID_ATN_TOKEN = "invalid_atn_token";
    public static final String ACCESS_NOT_PERMITTED = "Access not permitted.";
    public static final String ACCESS_NOT_PERMITTED_ALT = "Access+not+permitted.";

    AuthorizationResponseParser() {
    }

    Bundle extractResultsBundle(String uri, String requestId, String[] requestedScopes) throws AuthError {
        return this.extractResultsBundle(Uri.parse((String)uri), requestedScopes);
    }

    Bundle extractResultsBundle(Uri uri, String[] requestedScopes) throws AuthError {
        Bundle bundle = new Bundle();
        MAPLog.pii(LOG_TAG, "Received response from WebBroswer for OAuth2 flow", "response=" + uri.toString());
        bundle.putString(RESPONSE_URL, Base64.encodeToString((byte[])uri.toString().getBytes(), (int)0));
        String authzCode = uri.getQueryParameter(CODE);
        bundle.putString(CODE, authzCode);
        MAPLog.pii(LOG_TAG, "Code extracted from response", "code=" + authzCode);
        String error = uri.getQueryParameter(ERROR);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            String errorDescription = uri.getQueryParameter(ERROR_DESCRIPTION);
            return this.constructErrorBundle(bundle, error, errorDescription);
        }
        if (TextUtils.isEmpty((CharSequence)authzCode)) {
            throw new AuthError("No code in OAuth2 response", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
        }
        String scopes = uri.getQueryParameter(SCOPE);
        Map<String, String> stateValues = new ResponseUri(uri).getStateValues();
        return this.constructSuccessBundle(bundle, stateValues, scopes, requestedScopes);
    }

    private Bundle constructErrorBundle(Bundle bundle, String error, String errorDescription) throws AuthError {
        if (ERROR_ACCESS_DENIED.equals(error) && !TextUtils.isEmpty((CharSequence)errorDescription) && (ACCESS_NOT_PERMITTED.equals(errorDescription) || ACCESS_NOT_PERMITTED_ALT.equals(errorDescription))) {
            MAPLog.d(LOG_TAG, "Cancel response due to access denied");
            bundle.putInt(AuthzConstants.BUNDLE_KEY.CAUSE_ID.val, 0);
            bundle.putString(AuthzConstants.BUNDLE_KEY.ON_CANCEL_TYPE.val, error);
            bundle.putString(AuthzConstants.BUNDLE_KEY.ON_CANCEL_DESCRIPTION.val, errorDescription);
            return bundle;
        }
        AuthError.ERROR_TYPE errorType = AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE;
        if (ERROR_INVALID_ATN_TOKEN.equals(error)) {
            errorType = AuthError.ERROR_TYPE.ERROR_INVALID_TOKEN;
        }
        throw new AuthError("Error=" + error + " error_description=" + errorDescription, errorType);
    }

    private Bundle constructSuccessBundle(Bundle bundle, Map<String, String> stateValues, String scopes, String[] requestedScopes) {
        String clientId = stateValues.get(CLIENT_ID_STATE);
        bundle.putString(CLIENT_ID_STATE, clientId);
        String redirectUri = stateValues.get(REDIRECT_URI_STATE);
        bundle.putString(REDIRECT_URI_STATE, redirectUri);
        boolean returnAuthCode = Boolean.valueOf(stateValues.get(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val));
        bundle.putBoolean(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val, returnAuthCode);
        if (scopes != null) {
            bundle.putStringArray(SCOPE, ScopesHelper.getScopesFromString(scopes));
        } else {
            MAPLog.d(LOG_TAG, "No scopes from OAuth2 response, using requested scopes");
            bundle.putStringArray(SCOPE, requestedScopes);
        }
        return bundle;
    }
}

