/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device;

import android.net.Uri;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ResponseManager {
    private static final String LOG_TAG = ResponseManager.class.getName();
    static final int MAX_RESPONSES = 10;
    private final Map<String, Uri> pendingResponses = new LinkedHashMap<String, Uri>();
    private static ResponseManager INSTANCE = null;

    public static synchronized ResponseManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResponseManager();
        }
        return INSTANCE;
    }

    public int size() {
        return this.pendingResponses.size();
    }

    public synchronized boolean hasPendingResponseForRequest(String requestId) {
        return this.pendingResponses.containsKey(requestId);
    }

    public synchronized void putPendingResponse(String requestId, Uri responseUri) {
        if (requestId == null) {
            throw new IllegalArgumentException("requestId must be non-null");
        }
        if (responseUri == null) {
            throw new IllegalArgumentException("responseUri must be non-null");
        }
        while (this.pendingResponses.size() >= 10) {
            String requestToRemove = this.pendingResponses.keySet().iterator().next();
            MAPLog.d(LOG_TAG, "Purging pending response for request ID " + requestToRemove);
            this.pendingResponses.remove(requestToRemove);
        }
        MAPLog.d(LOG_TAG, "Recording pending response for request ID " + requestId);
        this.pendingResponses.put(requestId, responseUri);
    }

    public synchronized Uri removePendingResponse(String requestId) {
        MAPLog.d(LOG_TAG, "Dequeuing pending response for request ID " + requestId);
        return this.pendingResponses.remove(requestId);
    }
}

