/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.workflow;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.amazon.identity.auth.device.AbstractRequest;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.TokenHelper;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.OneTimeCodeRequest;
import com.amazon.identity.auth.device.endpoint.OneTimeCodeResponse;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.device.interactive.InteractiveRequest;
import com.amazon.identity.auth.device.workflow.WorkflowResponse;
import com.amazon.identity.auth.device.workflow.WorkflowToken;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkflowRequest
extends AbstractRequest {
    private static final String LOG_TAG = WorkflowRequest.class.getName();
    private static final String RELYING_PARTY_CONTEXT_PARAMETER_NAME = "rpContext";
    private static final String RP_CONTEXT_ONE_TIME_CODE_FIELD = "code";
    private static final String RP_CONTEXT_REDIRECT_URL_FIELD = "redirect_uri";
    private final ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
    private final String workflowUrl;
    private final WorkflowToken workflowToken;
    private final int minTokenLifetime;
    private final ServerCommunication serverCommunication;

    public WorkflowRequest(InteractiveRequest<?, ?, ?, ?> originalRequest, String workflowUrl, WorkflowToken workflowToken, int minTokenLifetime, ServerCommunication serverCommunication) throws AuthError {
        super(originalRequest);
        workflowToken.assertWorkflowUrlIsAllowed(workflowUrl);
        this.workflowUrl = workflowUrl;
        this.workflowToken = workflowToken;
        this.minTokenLifetime = minTokenLifetime;
        this.serverCommunication = serverCommunication;
    }

    @Override
    public int getMaxAttemptCount() {
        return 2;
    }

    @Override
    public String getUrl(Context context) throws AuthError {
        try {
            return Uri.parse((String)this.workflowUrl).buildUpon().appendQueryParameter(RELYING_PARTY_CONTEXT_PARAMETER_NAME, this.getRelyingPartyContextParameter(context)).build().toString();
        }
        catch (JSONException e) {
            throw new AuthError("Error while generating workflow URL", e, AuthError.ERROR_TYPE.ERROR_UNKNOWN);
        }
        catch (IOException e) {
            throw new AuthError("Error communicating with server", e, AuthError.ERROR_TYPE.ERROR_IO);
        }
    }

    @Override
    public boolean handleResponse(Uri uri, Context context) {
        MAPLog.pii(LOG_TAG, "Received response from workflow", "response=" + uri.toString());
        WorkflowResponse response = new WorkflowResponse(uri);
        if (response.isError() && response.isRecoverable()) {
            MAPLog.d(LOG_TAG, "Workflow response is a recoverable error. Retrying.");
            return false;
        }
        this.originalRequest.onRequestCompletion(context, this.getInteractiveRequestRecord(), uri);
        return true;
    }

    private String getRelyingPartyContextParameter(Context context) throws JSONException, IOException, AuthError {
        JSONObject rpContextJson = new JSONObject();
        rpContextJson.put(RP_CONTEXT_ONE_TIME_CODE_FIELD, (Object)this.getOneTimeCode(context));
        rpContextJson.put(RP_CONTEXT_REDIRECT_URL_FIELD, (Object)this.getRedirectUrl(context));
        rpContextJson.put("state", (Object)this.getStateField());
        return rpContextJson.toString();
    }

    private String getStateField() throws JSONException {
        return String.format("%s=%s&%s=%s", "clientRequestId", this.requestId, "InteractiveRequestType", this.originalRequest.getRequestType());
    }

    private String getOneTimeCode(Context context) throws IOException, AuthError {
        Bundle options = new Bundle();
        options.putInt(AuthzConstants.BUNDLE_KEY.MINIMUM_TOKEN_LIFETIME.val, this.minTokenLifetime);
        String accessToken = TokenHelper.getTokenInternal(context, context.getPackageName(), this.workflowToken.getScopes(), this.appIdentifier.getAppInfo(context.getPackageName(), context), options);
        if (accessToken == null) {
            throw new AuthError("Could not find token for scopes required to open workflow", AuthError.ERROR_TYPE.ERROR_MISSING_TOKEN_FOR_REQUIRED_SCOPES);
        }
        OneTimeCodeRequest createOneTimeCodeRequest = new OneTimeCodeRequest(context, this.workflowToken.getClientId(), accessToken, this.getAppInfo(context));
        OneTimeCodeResponse createOneTimeCodeResponse = this.serverCommunication.executeRequest(createOneTimeCodeRequest, context);
        return createOneTimeCodeResponse.getOneTimeCode();
    }

    private String getRedirectUrl(Context context) {
        return this.appIdentifier.getRedirectUrl(context);
    }

    private AppInfo getAppInfo(Context context) {
        return this.appIdentifier.getAppInfo(context.getPackageName(), context);
    }
}

