/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.interactive;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import com.amazon.identity.auth.device.api.InvalidIntegrationException;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.interactive.InteractiveState;
import com.amazon.identity.auth.device.interactive.InteractiveStateFragment;
import com.amazon.identity.auth.device.interactive.RequestSource;
import com.amazon.identity.auth.device.interactive.WorkflowFragment;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.lang.ref.WeakReference;

public final class RequestSourceActivityWrapper
implements RequestSource {
    private static final String LOG_TAG = RequestSourceActivityWrapper.class.getName();
    private static final String SDK_FRAGMENT_CLASS_NAME = "android.app.Fragment";
    private final WeakReference<Activity> activityReference;

    public RequestSourceActivityWrapper(Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must be non-null");
        }
        this.activityReference = new WeakReference<Activity>(activity);
    }

    public void onStartRequest(InteractiveRequestRecord request) {
        InteractiveState state = this.getInteractiveState();
        if (state != null) {
            state.onRequestStart(request);
        }
    }

    @SuppressLint(value={"NewApi"})
    public InteractiveState getInteractiveState() {
        Activity activity = (Activity)this.activityReference.get();
        if (activity != null) {
            this.assertFragmentsPresent();
            FragmentManager fragmentManager = activity.getFragmentManager();
            try {
                InteractiveStateFragment stateFragment = (InteractiveStateFragment)fragmentManager.findFragmentByTag(InteractiveStateFragment.TAG_ID);
                if (stateFragment == null) {
                    WorkflowFragment fragment = new WorkflowFragment();
                    fragmentManager.beginTransaction().add((Fragment)fragment, InteractiveStateFragment.TAG_ID).commit();
                    stateFragment = fragment;
                }
                return stateFragment.getState();
            }
            catch (ClassCastException e) {
                MAPLog.e(LOG_TAG, "Found an invalid fragment looking for fragment with tag " + InteractiveStateFragment.TAG_ID + ". Please use a different fragment tag.", e);
            }
        } else {
            MAPLog.e(LOG_TAG, "Failed to get InteractiveState on a garbage-collected Activity");
        }
        return null;
    }

    public Object getBackingObject() {
        return this.activityReference.get();
    }

    public Context getContext() {
        return (Context)this.activityReference.get();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activityReference == null || this.activityReference.get() == null ? 0 : ((Activity)this.activityReference.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestSourceActivityWrapper other = (RequestSourceActivityWrapper)obj;
        if (this.activityReference == null) {
            if (other.activityReference != null) {
                return false;
            }
        } else {
            if (other.activityReference == null) {
                return false;
            }
            if (this.activityReference.get() == null ? other.activityReference.get() != null : !((Activity)this.activityReference.get()).equals(other.activityReference.get())) {
                return false;
            }
        }
        return true;
    }

    private boolean assertFragmentsPresent() {
        try {
            return Class.forName(SDK_FRAGMENT_CLASS_NAME, false, this.getClass().getClassLoader()) != null;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidIntegrationException("android.app.Fragment not found. To make a request from an activity, use minSdkVersion of at least 11, or use FragmentActivity from Android Support Library v4", e);
        }
    }
}

