/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractJsonPandaRequest;
import com.amazon.identity.auth.device.endpoint.LogoutResponse;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogoutRequest
extends AbstractJsonPandaRequest<LogoutResponse> {
    private static final String LOG_TAG = LogoutRequest.class.getName();
    private static final String LOGOUT_ENDPOINT = "/auth/relyingPartyLogout";
    private static final String TOKEN = "token";
    private static final String BEARER = "bearer";
    private static final String TOKEN_TYPE = "token_type";
    private String authzToken;

    public LogoutRequest(Context context, AppInfo appInfo, String authzToken) {
        super(context, appInfo);
        this.authzToken = authzToken;
    }

    @Override
    protected LogoutResponse generateResponse(HttpResponse httpResponse) {
        return new LogoutResponse(httpResponse);
    }

    @Override
    protected List<BasicNameValuePair> getExtraParameters() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(TOKEN_TYPE, BEARER));
        params.add(new BasicNameValuePair(TOKEN, this.authzToken));
        return params;
    }

    @Override
    protected String getEndPoint() {
        return LOGOUT_ENDPOINT;
    }

    @Override
    protected void logRequest() {
        MAPLog.pii(LOG_TAG, "Executing logout request", "accessToken=" + this.authzToken);
    }
}

