/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.InvalidTokenAuthError;
import com.amazon.identity.auth.device.endpoint.PandaResponse;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractJSONTokenResponse
implements PandaResponse {
    private static final String LOG_TAG = AbstractJSONTokenResponse.class.getName();
    private static final String INVALID_TOKEN = "INVALID_TOKEN";
    private static final String JSON_MESSAGE_FIELD = "message";
    private static final String SERVER_ERROR = "ServerError";
    private static final String INVALID_SOURCE_TOKEN = "InvalidSourceToken";
    private static final String INVALID_TOKEN_CODE = "InvalidToken";
    private static final String JSON_CODE_FIELD = "code";
    protected static final String JSON_ERROR_FIELD = "error";
    private static final String FORCE_UPDATE_REQUESTED = "1";
    private static final String SERVER_ERROR_PAGE_IDENTIFIER = "!DOCTYPE html";
    private static final String DEFAULT_CHAR_SET = "UTF-8";
    protected static final String FORCE_UPDATE = "force_update";
    protected static final String TOKEN = "token";
    protected static final String COOKIE = "cookie";
    protected static final String RESPONSE = "response";
    public static final String REQUEST_ID = "request_id";
    public static final String VER_UNKOWN = "Unkown";
    public static final String EXPIRES_IN = "expires_in";
    public static final String TOKEN_EXPIRES_IN = "token_expires_in";
    public static final String TOKEN_TYPE = "token_type";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String REFRESH_TOKEN = "refresh_token";
    private final HttpResponse _response;
    private String _sEntity;

    public AbstractJSONTokenResponse(HttpResponse response) {
        this._response = response;
    }

    protected JSONObject getJSONResponse() throws IOException, JSONException {
        this._sEntity = this.getEntityString(this._response.getEntity()).trim();
        MAPLog.pii(LOG_TAG, "Entity Extracted", "entity=" + this._sEntity);
        JSONObject jHttpResponse = new JSONObject(this._sEntity);
        JSONObject jResponse = this.extractResponseJSONObject(jHttpResponse);
        this.logRequestId(jHttpResponse);
        return jResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEntityString(HttpEntity entity) throws IOException {
        InputStream contentStream = null;
        try {
            int currentSize;
            contentStream = entity.getContent();
            if (this.isGZIPEncoded(entity)) {
                contentStream = new GZIPInputStream(contentStream);
            }
            if (entity.getContentLength() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            String charset = EntityUtils.getContentCharSet((HttpEntity)entity);
            if (charset == null) {
                charset = DEFAULT_CHAR_SET;
            }
            ByteArrayOutputStream contentBytesOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((currentSize = contentStream.read(buffer)) != -1) {
                contentBytesOutputStream.write(buffer, 0, currentSize);
            }
            byte[] contentBytes = contentBytesOutputStream.toByteArray();
            String string = new String(contentBytes, charset);
            return string;
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
    }

    protected JSONObject extractResponseJSONObject(JSONObject jsonObject) throws JSONException {
        return jsonObject.getJSONObject(RESPONSE);
    }

    protected void logRequestId(JSONObject jHttpResponse) {
        try {
            String requestId = jHttpResponse.getString(REQUEST_ID);
            MAPLog.pii(LOG_TAG, "ExchangeRepsonse", "requestId=" + requestId);
        }
        catch (JSONException e) {
            MAPLog.w(LOG_TAG, "No RequestId in JSON response");
        }
    }

    protected String getEntity() {
        return this._sEntity;
    }

    public String getVersion() {
        return "3.5.3";
    }

    protected void handleForceUpdate(JSONObject jResponse) throws AuthError {
        block5: {
            String sForceUpdate = null;
            try {
                sForceUpdate = jResponse.getString(FORCE_UPDATE);
                if (sForceUpdate != null && sForceUpdate.equals(FORCE_UPDATE_REQUESTED)) {
                    String sVersion = this.getVersion();
                    MAPLog.e(LOG_TAG, "Force update requested ver:" + sVersion);
                    throw new AuthError("Server denied request, requested Force Update ver:" + sVersion, null, AuthError.ERROR_TYPE.ERROR_FORCE_UPDATE);
                }
            }
            catch (JSONException e) {
                if (!TextUtils.isEmpty((CharSequence)sForceUpdate)) {
                    MAPLog.e(LOG_TAG, "JSON exception parsing force update response:" + e.toString());
                    throw new AuthError(e.getMessage(), e, AuthError.ERROR_TYPE.ERROR_JSON);
                }
            }
            catch (ParseException e) {
                if (TextUtils.isEmpty((CharSequence)sForceUpdate)) break block5;
                MAPLog.e(LOG_TAG, "JSON parsing exception force update parsing response:" + e.toString());
                throw new AuthError(e.getMessage(), e, AuthError.ERROR_TYPE.ERROR_PARSE);
            }
        }
    }

    public void parse() throws AuthError {
        String additionalInfo = "";
        try {
            if (AbstractJSONTokenResponse.hasReceived500Error(this._response)) {
                additionalInfo = "500 error (status=" + this.getStatusCode() + ")";
            }
            JSONObject jResponse = this.getJSONResponse();
            this.handleJSONError(jResponse);
            this.doParse(jResponse);
            this.handleForceUpdate(jResponse);
        }
        catch (JSONException e) {
            if (this._sEntity != null && this._sEntity.contains(SERVER_ERROR_PAGE_IDENTIFIER)) {
                MAPLog.e(LOG_TAG, "Server sending back default error page - BAD request");
                throw new AuthError("Server sending back default error page - BAD request", e, AuthError.ERROR_TYPE.ERROR_JSON);
            }
            MAPLog.w(LOG_TAG, "JSON exception parsing " + additionalInfo + " response:" + e.toString());
            MAPLog.w(LOG_TAG, "JSON exception html = " + this._sEntity);
            throw new AuthError(e.getMessage(), e, AuthError.ERROR_TYPE.ERROR_JSON);
        }
        catch (ParseException e) {
            MAPLog.e(LOG_TAG, "Exception parsing " + additionalInfo + " response:" + e.toString());
            throw new AuthError(e.getMessage(), e, AuthError.ERROR_TYPE.ERROR_PARSE);
        }
        catch (IOException e) {
            MAPLog.e(LOG_TAG, "Exception accessing " + additionalInfo + " response:" + e.toString());
            throw new AuthError(e.getMessage(), e, AuthError.ERROR_TYPE.ERROR_COM);
        }
        finally {
            try {
                this._response.getEntity().getContent().close();
            }
            catch (IllegalStateException e) {
                MAPLog.i(LOG_TAG, "IllegalStateException closing response " + e.toString());
            }
            catch (IOException e) {
                MAPLog.e(LOG_TAG, "IOException closing response " + e.toString());
            }
        }
    }

    private boolean isGZIPEncoded(HttpEntity entity) {
        Header ceheader = entity.getContentEncoding();
        if (ceheader != null) {
            HeaderElement[] codecs = ceheader.getElements();
            for (int i = 0; i < codecs.length; ++i) {
                if (!codecs[i].getName().equalsIgnoreCase("gzip")) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void doParse(JSONObject var1) throws IOException, JSONException, AuthError;

    protected void handleJSONError(JSONObject jResponse) throws AuthError, JSONException {
        block11: {
            JSONObject errorObject = null;
            try {
                errorObject = jResponse.getJSONObject(JSON_ERROR_FIELD);
                String sErrorCode = errorObject.getString(JSON_CODE_FIELD);
                if (SERVER_ERROR.equalsIgnoreCase(sErrorCode)) {
                    String sErrorMessage = errorObject.getString(JSON_MESSAGE_FIELD);
                    if (sErrorMessage.startsWith(INVALID_TOKEN)) {
                        throw new InvalidTokenAuthError("Invalid Exchange parameter - SERVER_ERROR.");
                    }
                    this.throwUnknownAuthError(sErrorCode);
                } else {
                    if (INVALID_SOURCE_TOKEN.equalsIgnoreCase(sErrorCode)) {
                        throw new InvalidTokenAuthError("Invalid Source Token in exchange parameter");
                    }
                    if (INVALID_TOKEN_CODE.equals(sErrorCode)) {
                        throw new InvalidTokenAuthError("Token used is invalid.");
                    }
                    if (AbstractJSONTokenResponse.hasReceived500Error(this._response)) {
                        this.throwUnknownAuthError("500 error (status=" + this.getStatusCode() + ")" + sErrorCode);
                    } else {
                        this.throwUnknownAuthError(sErrorCode);
                    }
                }
            }
            catch (JSONException e) {
                if (errorObject != null) {
                    throw new AuthError("JSON exception parsing json error response:", e, AuthError.ERROR_TYPE.ERROR_JSON);
                }
            }
            catch (ParseException e) {
                if (errorObject == null) break block11;
                throw new AuthError("Exception parsing response", e, AuthError.ERROR_TYPE.ERROR_PARSE);
            }
        }
    }

    public void throwUnknownAuthError(String sErrorCode) throws AuthError {
        String error = String.format("Error code: %s Server response: %s", sErrorCode, this._sEntity);
        throw new AuthError("Server Error : " + error, AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
    }

    protected long getExpiresIn(JSONObject jResponse) {
        long expiresIn = 0L;
        try {
            if (jResponse.has(TOKEN_EXPIRES_IN)) {
                expiresIn = jResponse.getLong(TOKEN_EXPIRES_IN);
            } else if (jResponse.has(EXPIRES_IN)) {
                expiresIn = jResponse.getLong(EXPIRES_IN);
            } else {
                MAPLog.w(LOG_TAG, "Unable to find expiration time in JSON response, AccessToken will not expire locally");
            }
        }
        catch (JSONException e) {
            MAPLog.e(LOG_TAG, "Unable to parse expiration time in JSON response, AccessToken will not expire locally");
        }
        return expiresIn;
    }

    public int getStatusCode() throws AuthError {
        try {
            return this._response.getStatusLine().getStatusCode();
        }
        catch (NullPointerException npe) {
            throw new AuthError("StatusLine is null", npe, AuthError.ERROR_TYPE.ERROR_COM);
        }
    }

    public static boolean hasReceived500Error(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return code >= 500 && code <= 599;
    }

    protected HttpResponse getResponse() {
        return this._response;
    }
}

