/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import com.amazon.identity.auth.device.StoredPreferences;
import com.amazon.identity.auth.device.api.authorization.Region;
import com.amazon.identity.auth.device.authorization.Service;
import com.amazon.identity.auth.device.authorization.Stage;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.utils.DefaultLibraryInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class EndpointDomainBuilder {
    private static final String HTTPS = "https://";
    private static final boolean REGULAR = false;
    private static final boolean SANDBOX = true;
    private static Map<String, String> allDomainsMap = new HashMap<String, String>();
    private static Map<String, Region> domainToRegionMap = new HashMap<String, Region>();
    private Service service;
    private Stage stage = Stage.PROD;
    private boolean isSandbox = false;
    private Region region = Region.NA;
    private String pandaEndpointFromAPIKey;

    public EndpointDomainBuilder(Context context, AppInfo appInfo) {
        this.region = StoredPreferences.getRegion(context);
        this.stage = DefaultLibraryInfo.getOverrideLibraryStage();
        if (appInfo != null) {
            this.pandaEndpointFromAPIKey = appInfo.getExchangeHost();
        }
    }

    public EndpointDomainBuilder forService(Service service) {
        this.service = service;
        return this;
    }

    public EndpointDomainBuilder forStage(Stage stage) {
        this.stage = stage;
        return this;
    }

    public EndpointDomainBuilder forSandbox(boolean isSandbox) {
        this.isSandbox = isSandbox;
        return this;
    }

    public EndpointDomainBuilder forRegion(Region region) {
        this.region = region;
        return this;
    }

    public String getDomain() throws MalformedURLException {
        if (Region.AUTO == this.region) {
            this.region = this.getRegionForAPIKey();
        }
        String key = EndpointDomainBuilder.getKey(this.service, this.stage, this.isSandbox, this.region);
        return allDomainsMap.get(key);
    }

    public Region getRegionForAPIKey() {
        Region result = Region.NA;
        try {
            if (this.pandaEndpointFromAPIKey != null) {
                result = domainToRegionMap.get(this.getDomainFor(this.pandaEndpointFromAPIKey));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    private static void addEndpoint(Service service, Stage stage, boolean isSandbox, Region region, String domainName) {
        String key = EndpointDomainBuilder.getKey(service, stage, isSandbox, region);
        allDomainsMap.put(key, domainName);
        if (Region.AUTO != region && Service.PANDA == service) {
            domainToRegionMap.put(domainName, region);
        }
    }

    private String getDomainFor(String endpointFromAPIKey) throws MalformedURLException {
        return HTTPS + new URL(endpointFromAPIKey).getHost();
    }

    private static String getKey(Service service, Stage stage, boolean isSandbox, Region region) {
        return String.format("%s.%s.%s.%s", service.toString(), stage.toString(), isSandbox, region.toString());
    }

    static {
        EndpointDomainBuilder.addEndpoint(Service.AUTHORIZATION, Stage.DEVO, false, Region.NA, "https://na-account.integ.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.AUTHORIZATION, Stage.DEVO, false, Region.EU, "https://eu-account.integ.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.AUTHORIZATION, Stage.DEVO, false, Region.FE, "https://apac-account.integ.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.AUTHORIZATION, Stage.PRE_PROD, false, Region.NA, "https://na.account.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.AUTHORIZATION, Stage.PRE_PROD, false, Region.EU, "https://eu.account.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.AUTHORIZATION, Stage.PRE_PROD, false, Region.FE, "https://apac.account.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.AUTHORIZATION, Stage.PROD, false, Region.NA, "https://na.account.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.AUTHORIZATION, Stage.PROD, false, Region.EU, "https://eu.account.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.AUTHORIZATION, Stage.PROD, false, Region.FE, "https://apac.account.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.DEVO, true, Region.NA, "https://api-sandbox.integ.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.DEVO, true, Region.EU, "https://api-sandbox.integ.amazon.co.uk");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.DEVO, true, Region.FE, "https://api-sandbox-jp.integ.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.DEVO, false, Region.NA, "https://api.integ.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.DEVO, false, Region.EU, "https://api.integ.amazon.co.uk");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.DEVO, false, Region.FE, "https://api.integ.amazon.co.jp");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PRE_PROD, true, Region.NA, "https://api.sandbox.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PRE_PROD, true, Region.EU, "https://api.sandbox.amazon.co.uk");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PRE_PROD, true, Region.FE, "https://api-sandbox.amazon.co.jp");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PRE_PROD, false, Region.NA, "https://api-preprod.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PRE_PROD, false, Region.EU, "https://api-preprod.amazon.co.uk");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PRE_PROD, false, Region.FE, "https://api-preprod.amazon.co.jp");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PROD, true, Region.NA, "https://api.sandbox.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PROD, true, Region.EU, "https://api.sandbox.amazon.co.uk");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PROD, true, Region.FE, "https://api-sandbox.amazon.co.jp");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PROD, false, Region.NA, "https://api.amazon.com");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PROD, false, Region.EU, "https://api.amazon.co.uk");
        EndpointDomainBuilder.addEndpoint(Service.PANDA, Stage.PROD, false, Region.FE, "https://api.amazon.co.jp");
    }
}

