/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.api.Listener;
import com.amazon.identity.auth.device.authorization.InternalAuthManager;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.utils.LWAConstants;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class User {
    private static final String LOG_TAG = User.class.getName();
    private final Map<String, String> userInfo;

    User(Map<String, String> userInfo) {
        this.userInfo = userInfo;
    }

    public static void fetch(Context context, Listener<User, AuthError> listener) {
        User.fetch(context, InternalAuthManager.getInstance(context), listener);
    }

    static void fetch(Context context, InternalAuthManager authManager, final Listener<User, AuthError> listener) {
        MAPLog.i(LOG_TAG, context.getPackageName() + " calling fetch");
        Bundle options = new Bundle();
        options.putBoolean(LWAConstants.PROFILE_BUNDLE_KEY.FAIL_ON_INSUFFICIENT_SCOPE.val, true);
        authManager.getProfile(context, options, new APIListener(){

            public void onSuccess(Bundle response) {
                listener.onSuccess(User.userFromBundle(response.getBundle(AuthzConstants.BUNDLE_KEY.PROFILE.val)));
            }

            public void onError(AuthError e) {
                listener.onError(e);
            }
        });
    }

    public String getUserId() {
        return this.userInfo.get(AuthzConstants.PROFILE_KEY.USER_ID.val);
    }

    public String getUserName() {
        return this.userInfo.get(AuthzConstants.PROFILE_KEY.NAME.val);
    }

    public String getUserEmail() {
        return this.userInfo.get(AuthzConstants.PROFILE_KEY.EMAIL.val);
    }

    public String getUserPostalCode() {
        return this.userInfo.get(AuthzConstants.PROFILE_KEY.POSTAL_CODE.val);
    }

    public Map<String, String> getUserInfo() {
        return this.userInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userInfo == null ? 0 : this.userInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.userInfo == null ? other.userInfo != null : !this.userInfo.equals(other.userInfo));
    }

    public String toString() {
        return String.format("%s={userInfo=%s}", super.toString(), this.userInfo);
    }

    static User userFromBundle(Bundle bundle) {
        HashMap<String, String> map = new HashMap<String, String>(bundle.size());
        for (String key : bundle.keySet()) {
            map.put(key, bundle.getString(key));
        }
        return new User(map);
    }
}

