/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.AppIdentifier;
import com.amazon.identity.auth.device.authorization.ScopesHelper;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.RequestedScope;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.device.utils.HashAlgorithm;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.device.utils.PackageSignatureUtil;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationHelper {
    private static final String LOG_TAG = AuthorizationHelper.class.getName();
    private static final String HTTPS = "https";
    private static final String LANGUAGE_PARAMETER = "&language=";
    public static final String AUTHZ_QUERY_PARAMS = "authzParams";
    private static final String LWA_ANDROID_SESSION_EXPIRED_ERROR_CODE = "400";
    private static final String LWA_ANDROID_SESSION_EXPIRED_TITLE = "lwa-android-session-expired-title";
    private static final String LWA_ANDROID_SESSION_EXPIRED_BODY = "lwa-android-session-expired-body";

    public static String[] getCommonScopesForAuthorization(Context context, String[] requestedScopes, List<RequestedScope> cachedScopes) {
        List<String> requestedScopesList = Arrays.asList(requestedScopes);
        ArrayList<String> commonScopes = new ArrayList<String>();
        commonScopes.addAll(requestedScopesList);
        if (cachedScopes != null) {
            for (RequestedScope cachedScope : cachedScopes) {
                String cachedScopeName = cachedScope.getScopeValue();
                if (commonScopes.contains(cachedScopeName)) continue;
                commonScopes.add(cachedScopeName);
            }
        }
        return commonScopes.toArray(new String[commonScopes.size()]);
    }

    void doCodeForTokenExchange(final Context context, final String packageName, final String codeVerifier, final Bundle response, final boolean returnResponseUrl, final String directedId, final TokenVendor tokenVendor, final AppIdentifier appIdentifier, final AuthorizationListener listener) {
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                if (response != null) {
                    AuthorizationHelper.this.startCodeForTokenExchange(context, packageName, codeVerifier, directedId, tokenVendor, appIdentifier, response, returnResponseUrl, listener);
                    return;
                }
                listener.onError(new AuthError("Response bundle from Authorization was null", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE));
            }
        });
    }

    void doCodeForTokenExchange(Context context, String packageName, Bundle response, boolean returnResponseUrl, String directedId, TokenVendor tokenVendor, AppIdentifier appIdentifier, AuthorizationListener listener) {
        this.doCodeForTokenExchange(context, packageName, null, response, returnResponseUrl, directedId, tokenVendor, appIdentifier, listener);
    }

    private void startCodeForTokenExchange(Context context, String packageName, String codeVerifier, String directedId, TokenVendor tokenVendor, AppIdentifier appIdentifier, Bundle response, boolean returnResponseUrl, AuthorizationListener listener) {
        if (ThreadUtils.isRunningOnMainThread()) {
            MAPLog.e(LOG_TAG, "code for token exchange started on main thread");
            throw new IllegalStateException("authorize started on main thread");
        }
        String code = response.getString("code");
        if (!TextUtils.isEmpty((CharSequence)code)) {
            String clientId = response.getString("clientId");
            String redirectUri = response.getString("redirectUri");
            Object[] scopes = response.getStringArray("scope");
            String responseUrl = response.getString("responseUrl");
            boolean isSandboxMode = response.getBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, false);
            MAPLog.pii(LOG_TAG, "Params extracted from OAuth2 response", "code=" + code + "clientId=" + clientId + " redirectUri=" + redirectUri + " directedId=" + directedId + " scopes=" + Arrays.toString(scopes) + " sandboxMode=" + isSandboxMode);
            AppInfo appInfo = appIdentifier.getAppInfo(packageName, context);
            if (appInfo != null) {
                try {
                    Bundle result = tokenVendor.vendNewTokensFromCode(code, codeVerifier, redirectUri, (String[])scopes, directedId, context, isSandboxMode, appInfo);
                    if (returnResponseUrl) {
                        result.putString("responseUrl", responseUrl);
                    }
                    listener.onSuccess(result);
                }
                catch (IOException e) {
                    listener.onError(new AuthError("Failed to exchange code for token", e, AuthError.ERROR_TYPE.ERROR_IO));
                }
                catch (AuthError e) {
                    MAPLog.e(LOG_TAG, "Failed doing code for token exchange " + e.getMessage());
                    listener.onError(e);
                }
            } else {
                MAPLog.e(LOG_TAG, "Unable to extract AppInfo for " + packageName);
                listener.onError(new AuthError("Unable to extract AppInfo", AuthError.ERROR_TYPE.ERROR_UNKNOWN));
            }
        } else {
            listener.onError(new AuthError("Response bundle from Authorization was empty", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE));
        }
    }

    public static String getOAuth2Url(Context context, String packageName, String clientId, String[] scopes, String requestId, boolean doRememberMe, boolean skipSignIn, Bundle options, AppInfo appInfo) throws AuthError {
        URL url = null;
        boolean isSandboxMode = options.getBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, false);
        String customHost = null;
        if (appInfo != null) {
            customHost = appInfo.getAuthorizationHost();
        }
        if (!TextUtils.isEmpty(customHost) && !isSandboxMode) {
            try {
                url = new URL(customHost + AuthorizationHelper.getQueryString(context, packageName, clientId, scopes, requestId, doRememberMe, skipSignIn, options) + AuthorizationHelper.getLanguageParameter() + AuthorizationHelper.getCustomQueryParams(options));
            }
            catch (MalformedURLException e) {
                throw new AuthError("MalformedURLException on custom host", e, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
            }
        }
        String host = AuthorizationHelper.getHost(context, packageName);
        String endPoint = AuthorizationHelper.getEndPoint() + AuthorizationHelper.getQueryString(context, packageName, clientId, scopes, requestId, doRememberMe, skipSignIn, options) + AuthorizationHelper.getLanguageParameter() + AuthorizationHelper.getCustomQueryParams(options);
        try {
            url = new URL(HTTPS, host, endPoint);
        }
        catch (MalformedURLException e) {
            throw new AuthError("MalformedURLException", e, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
        MAPLog.pii(LOG_TAG, "Generating OAUTH2 URL", "url=" + url.toString());
        return url.toString();
    }

    public static String getOAuth2ErrorUrl(Context context) {
        URL url = null;
        String host = AuthorizationHelper.getHost(context, context.getPackageName());
        String endPoint = AuthorizationHelper.getErrorEndPoint() + AuthorizationHelper.getErrorQueryParamsString() + AuthorizationHelper.getLanguageParameter();
        try {
            url = new URL(HTTPS, host, endPoint);
        }
        catch (MalformedURLException e) {
            MAPLog.w(LOG_TAG, "Unable to generate OAuth2Error URL");
        }
        MAPLog.pii(LOG_TAG, "Generating OAuth2Error URL", "url=" + url.toString());
        return url.toString();
    }

    private static String getErrorQueryParamsString() {
        StringBuilder queryParams = new StringBuilder("?");
        queryParams.append(AuthorizationHelper.getUrlEncodedQuery("errorCode", LWA_ANDROID_SESSION_EXPIRED_ERROR_CODE)).append("&");
        queryParams.append(AuthorizationHelper.getUrlEncodedQuery("title", LWA_ANDROID_SESSION_EXPIRED_TITLE)).append("&");
        queryParams.append(AuthorizationHelper.getUrlEncodedQuery("message", LWA_ANDROID_SESSION_EXPIRED_BODY)).append("&");
        queryParams.append(AuthorizationHelper.getUrlEncodedQuery("applicationName", ""));
        return queryParams.toString();
    }

    public static String getCustomQueryParams(Bundle authzQueryParameters) {
        Bundle authzParams = authzQueryParameters.getBundle(AUTHZ_QUERY_PARAMS);
        StringBuffer queryParams = new StringBuffer("");
        if (authzParams != null) {
            Set keySet = authzParams.keySet();
            for (String key : keySet) {
                queryParams.append('&');
                queryParams.append(AuthorizationHelper.getUrlEncodedQuery(key, authzParams.getString(key)));
            }
        }
        return queryParams.toString();
    }

    private static String getLanguageParameter() {
        return LANGUAGE_PARAMETER + Locale.getDefault().toString();
    }

    private static String getRedirectUri(String packageName) {
        String rediectUri = "amzn://" + packageName;
        MAPLog.pii(LOG_TAG, "Generating Redirect URI", "rediectUri=" + rediectUri);
        return rediectUri;
    }

    private static String getHost(Context context, String packageName) {
        return MAPUtils.getHostType(context, packageName) + ".amazon.com";
    }

    private static String getEndPoint() {
        return "/ap/oa";
    }

    private static String getErrorEndPoint() {
        return "/ap/oacerror";
    }

    private static String getQueryString(Context context, String packageName, String clientId, String[] scopes, String requestId, boolean doRememberMe, boolean skipSignIn, Bundle options) {
        String state;
        boolean isSandboxMode;
        StringBuffer sb = new StringBuffer("?");
        String redirectUri = AuthorizationHelper.getRedirectUri(packageName);
        sb.append(AuthorizationHelper.getUrlEncodedQuery("response_type", "code"));
        sb.append("&");
        sb.append(AuthorizationHelper.getUrlEncodedQuery("redirect_uri", redirectUri));
        if (clientId != null) {
            sb.append("&");
            sb.append(AuthorizationHelper.getUrlEncodedQuery("client_id", clientId));
        }
        sb.append("&");
        if (doRememberMe) {
            sb.append(AuthorizationHelper.getUrlEncodedQuery("amzn_respectRmrMeAuthState", "1"));
            sb.append("&");
            sb.append(AuthorizationHelper.getUrlEncodedQuery("amzn_showRmrMe", "1"));
            sb.append("&");
            sb.append(AuthorizationHelper.getUrlEncodedQuery("amzn_rmrMeDefaultSelected", "1"));
            sb.append("&");
        }
        if (skipSignIn) {
            sb.append(AuthorizationHelper.getUrlEncodedQuery("skipSignIn", "1"));
            sb.append("&");
        }
        if (isSandboxMode = options.getBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, false)) {
            sb.append(AuthorizationHelper.getUrlEncodedQuery("sandbox", "true"));
            sb.append("&");
        }
        if ((state = clientId) == null) {
            state = requestId;
        }
        boolean returnAuthCode = options.getBoolean(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val, false);
        StringBuilder stateBuilder = new StringBuilder();
        stateBuilder.append("clientId=" + state + "&");
        stateBuilder.append("redirectUri=" + redirectUri + "&");
        stateBuilder.append("clientRequestId=" + requestId.toString() + "&");
        stateBuilder.append(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val + "=" + String.valueOf(returnAuthCode));
        sb.append(AuthorizationHelper.getUrlEncodedQuery("state", stateBuilder.toString()));
        sb.append("&");
        String scopeString = ScopesHelper.getScopesString(scopes);
        sb.append(AuthorizationHelper.getUrlEncodedQuery("scope", scopeString));
        sb.append("&");
        sb.append(AuthorizationHelper.getUrlEncodedQuery("appIdentifier", AuthorizationHelper.getAppIdentifierBlob(context, packageName)));
        sb.append("&");
        sb.append(AuthorizationHelper.getFilteredParams(options.getBundle(AuthzConstants.BUNDLE_KEY.EXTRA_URL_PARAMS.val)));
        return sb.toString();
    }

    private static String getAppIdentifierBlob(Context context, String packageName) {
        JSONObject appIdentifierBlob = new JSONObject();
        try {
            appIdentifierBlob.put("package", (Object)packageName);
            for (HashAlgorithm algo : HashAlgorithm.values()) {
                appIdentifierBlob.put(algo.getAlgorithmName(), (Object)new JSONArray(PackageSignatureUtil.getAllSignaturesFor(packageName, algo, context)));
            }
        }
        catch (JSONException e) {
            MAPLog.e(LOG_TAG, "Encountered exception while generating app identifier blob", e);
            return null;
        }
        return Base64.encodeToString((byte[])appIdentifierBlob.toString().getBytes(), (int)0);
    }

    private static String getFilteredParams(Bundle parameterBundle) {
        if (parameterBundle == null) {
            return "";
        }
        StringBuilder strippedParamList = new StringBuilder();
        for (String paramKey : parameterBundle.keySet()) {
            AuthzConstants.BUNDLE_KEY[] knownKeys;
            String paramValue = parameterBundle.getString(paramKey);
            boolean matched = false;
            for (AuthzConstants.BUNDLE_KEY key : knownKeys = AuthzConstants.BUNDLE_KEY.values()) {
                if (!key.val.equalsIgnoreCase(paramKey)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            strippedParamList.append(AuthorizationHelper.getUrlEncodedQuery(paramKey, paramValue));
            strippedParamList.append("&");
        }
        if (strippedParamList.length() > 0) {
            strippedParamList.deleteCharAt(strippedParamList.length() - 1);
        }
        String result = strippedParamList.toString();
        return result;
    }

    private static String getUrlEncodedQuery(String name, String value) {
        name = URLEncoder.encode(name);
        StringBuilder sb = new StringBuilder(name);
        sb.append("=");
        if (value != null) {
            sb.append(URLEncoder.encode(value));
        }
        return sb.toString();
    }

    public static void sendAuthorizationCodeAsResponse(String code, AuthorizationListener listener) {
        block4: {
            try {
                if (TextUtils.isEmpty((CharSequence)code)) {
                    throw new AuthError("Response bundle from Authorization does not contain authorization code", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
                }
                Bundle response = new Bundle();
                response.putString(AuthzConstants.BUNDLE_KEY.AUTHORIZATION_CODE.val, code);
                MAPLog.i(LOG_TAG, "Return auth code success");
                if (listener != null) {
                    listener.onSuccess(response);
                }
            }
            catch (AuthError e) {
                MAPLog.e(LOG_TAG, "Return auth code error. " + e.getMessage());
                if (listener == null) break block4;
                listener.onError(e);
            }
        }
    }
}

