/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.interfaces.system;

import android.util.Log;
import com.willblaschko.android.alexa.callbacks.AsyncCallback;
import com.willblaschko.android.alexa.connection.ClientUtil;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.SendEvent;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

public class OpenDownchannel
extends SendEvent {
    private static final String TAG = "OpenDownchannel";

    public OpenDownchannel(String url, String accessToken, AsyncCallback<AvsResponse, Exception> callback) throws IOException {
        if (callback != null) {
            callback.start();
        }
        Log.i((String)TAG, (String)"Starting Open Downchannel procedure");
        long start = System.currentTimeMillis();
        try {
            OkHttpClient client = ClientUtil.getTLS12OkHttpClient();
            Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + accessToken).build();
            client.newCall(request).execute();
            Log.i((String)TAG, (String)"Downchannel open");
            Log.i((String)TAG, (String)("Open Downchannel process took: " + (System.currentTimeMillis() - start)));
        }
        catch (IOException e) {
            this.onError(callback, e);
        }
    }

    private void onError(AsyncCallback<AvsResponse, Exception> callback, Exception e) {
        if (callback != null) {
            callback.failure(e);
            callback.complete();
        }
    }

    @Override
    @NotNull
    protected String getEvent() {
        return "";
    }
}

