/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.interfaces.response;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.willblaschko.android.alexa.data.Directive;
import com.willblaschko.android.alexa.interfaces.AvsException;
import com.willblaschko.android.alexa.interfaces.AvsItem;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.alerts.AvsSetAlertItem;
import com.willblaschko.android.alexa.interfaces.audioplayer.AvsPlayAudioItem;
import com.willblaschko.android.alexa.interfaces.audioplayer.AvsPlayRemoteItem;
import com.willblaschko.android.alexa.interfaces.errors.AvsResponseException;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsMediaNextCommandItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsMediaPauseCommandItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsMediaPlayCommandItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsMediaPreviousCommandItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsReplaceAllItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsReplaceEnqueuedItem;
import com.willblaschko.android.alexa.interfaces.speaker.AvsAdjustVolumeItem;
import com.willblaschko.android.alexa.interfaces.speaker.AvsSetMuteItem;
import com.willblaschko.android.alexa.interfaces.speaker.AvsSetVolumeItem;
import com.willblaschko.android.alexa.interfaces.speechrecognizer.AvsExpectSpeechItem;
import com.willblaschko.android.alexa.interfaces.speechsynthesizer.AvsSpeakItem;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.internal.Util;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;

public class ResponseParser {
    public static final String TAG = "ResponseParser";

    public static AvsResponse parseResponse(InputStream stream, String boundary) throws IOException, IllegalStateException, AvsException {
        long start = System.currentTimeMillis();
        ArrayList<Directive> directives = new ArrayList<Directive>();
        HashMap<String, ByteArrayInputStream> audio = new HashMap<String, ByteArrayInputStream>();
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        String responseString = ResponseParser.string(bytes);
        MultipartStream mpStream = new MultipartStream((InputStream)new ByteArrayInputStream(bytes), boundary.getBytes(), 100000, null);
        Pattern pattern = Pattern.compile("<(.*?)>");
        if (mpStream.skipPreamble()) {
            Log.i((String)TAG, (String)"Found initial boundary: true");
            for (int count = 0; count < 1 || mpStream.readBoundary(); ++count) {
                String headers = mpStream.readHeaders();
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                mpStream.readBodyData((OutputStream)data);
                if (!ResponseParser.isJson(headers)) {
                    Matcher matcher;
                    String contentId = ResponseParser.getCID(headers);
                    if (contentId == null || !(matcher = pattern.matcher(contentId)).find()) continue;
                    String currentId = "cid:" + matcher.group(1);
                    audio.put(currentId, new ByteArrayInputStream(data.toByteArray()));
                    continue;
                }
                String directive = data.toString(Charset.defaultCharset().displayName());
                directives.add(ResponseParser.getDirective(directive));
            }
        } else {
            Log.i((String)TAG, (String)("Response Body: \n" + ResponseParser.string(bytes)));
            try {
                directives.add(ResponseParser.getDirective(responseString));
            }
            catch (JsonParseException e) {
                e.printStackTrace();
                throw new AvsException("Response from Alexa server malformed. ");
            }
        }
        AvsResponse response = new AvsResponse();
        for (Directive directive : directives) {
            ByteArrayInputStream sound;
            Log.i((String)TAG, (String)("Parsing directive type: " + directive.getHeader().getNamespace() + ":" + directive.getHeader().getName()));
            if (directive.isPlayBehaviorReplaceAll()) {
                response.add(0, new AvsReplaceAllItem(directive.getPayload().getToken()));
            }
            if (directive.isPlayBehaviorReplaceEnqueued()) {
                response.add(new AvsReplaceEnqueuedItem(directive.getPayload().getToken()));
            }
            AvsItem item = null;
            if (directive.isTypeSpeak()) {
                String cid = directive.getPayload().getUrl();
                sound = (ByteArrayInputStream)audio.get(cid);
                item = new AvsSpeakItem(directive.getPayload().getToken(), cid, sound);
            } else if (directive.isTypePlay()) {
                String url = directive.getPayload().getAudioItem().getStream().getUrl();
                if (url.contains("cid:")) {
                    sound = (ByteArrayInputStream)audio.get(url);
                    item = new AvsPlayAudioItem(directive.getPayload().getToken(), url, sound);
                } else {
                    item = new AvsPlayRemoteItem(directive.getPayload().getToken(), url, directive.getPayload().getAudioItem().getStream().getOffsetInMilliseconds());
                }
            } else if (directive.isTypeSetAlert()) {
                item = new AvsSetAlertItem(directive.getPayload().getToken(), directive.getPayload().getType(), directive.getPayload().getScheduledTime());
                response.add(item);
            } else if (directive.isTypeSetMute()) {
                item = new AvsSetMuteItem(directive.getPayload().getToken(), directive.getPayload().isMute());
            } else if (directive.isTypeSetVolume()) {
                item = new AvsSetVolumeItem(directive.getPayload().getToken(), directive.getPayload().getVolume());
            } else if (directive.isTypeAdjustVolume()) {
                item = new AvsAdjustVolumeItem(directive.getPayload().getToken(), directive.getPayload().getVolume());
            } else if (directive.isTypeExpectSpeech()) {
                item = new AvsExpectSpeechItem(directive.getPayload().getToken(), directive.getPayload().getTimeoutInMilliseconds());
            } else if (directive.isTypeMediaPlay()) {
                item = new AvsMediaPlayCommandItem(directive.getPayload().getToken());
            } else if (directive.isTypeMediaPause()) {
                item = new AvsMediaPauseCommandItem(directive.getPayload().getToken());
            } else if (directive.isTypeMediaNext()) {
                item = new AvsMediaNextCommandItem(directive.getPayload().getToken());
            } else if (directive.isTypeMediaPrevious()) {
                item = new AvsMediaPreviousCommandItem(directive.getPayload().getToken());
            } else if (directive.isTypeException()) {
                item = new AvsResponseException(directive);
            }
            if (item == null) continue;
            response.add(item);
        }
        Log.i((String)TAG, (String)("Parsing response took: " + (System.currentTimeMillis() - start)));
        return response;
    }

    private static final String string(byte[] bytes) throws IOException {
        return new String(bytes, Util.UTF_8);
    }

    private static Directive getDirective(String directive) {
        Gson gson = new Gson();
        Directive.DirectiveWrapper wrapper = (Directive.DirectiveWrapper)gson.fromJson(directive, Directive.DirectiveWrapper.class);
        if (wrapper.getDirective() == null) {
            return (Directive)gson.fromJson(directive, Directive.class);
        }
        return wrapper.getDirective();
    }

    private static String getCID(String headers) throws IOException {
        String contentString = "Content-ID:";
        BufferedReader reader = new BufferedReader(new StringReader(headers));
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("Content-ID:")) {
                return line.substring("Content-ID:".length()).trim();
            }
            line = reader.readLine();
        }
        return null;
    }

    private static boolean isJson(String headers) {
        return headers.contains("application/json");
    }
}

