/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.map.device.token;

import android.text.TextUtils;
import android.text.format.Time;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.map.device.AccountManagerConstants;
import com.amazon.identity.auth.map.device.token.Token;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToken
implements Token {
    private static final String LOG_TAG = AbstractToken.class.getName();
    public static final String KEY_CREATION_TIME = "creation_time";
    public static final String KEY_EXPIRES_IN = "expires_in";
    public static final long NEVER_EXPIRE = 0L;
    public static final long ALWAYS_EXPIRE = -1L;
    private final String _token;
    protected final Time localCreationTimestamp = new Time();
    protected Map<String, String> tokenData;

    private AbstractToken() {
        this._token = null;
    }

    public AbstractToken(AbstractToken token) {
        if (token == null || TextUtils.isEmpty((CharSequence)token.getToken())) {
            throw new IllegalArgumentException("Token string may not be null for an AbstractToken");
        }
        this._token = token.getToken();
        this.localCreationTimestamp.set(token.localCreationTimestamp);
        this.tokenData = new HashMap<String, String>(token.tokenData);
    }

    public AbstractToken(String token) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            throw new IllegalArgumentException("Token string may not be null for an AbstractToken");
        }
        this._token = token;
        this.localCreationTimestamp.setToNow();
        this.tokenData = new HashMap<String, String>();
        this.initTokenData();
    }

    public AbstractToken(Map<String, String> tokenData) throws AuthError {
        this._token = tokenData.get("token");
        if (TextUtils.isEmpty((CharSequence)this._token)) {
            throw new IllegalArgumentException("Token string may not be null for an AbstractToken");
        }
        this.tokenData = tokenData;
        String creationTimeMillis = tokenData.get(KEY_CREATION_TIME);
        if (null == creationTimeMillis) {
            MAPLog.i(LOG_TAG, "creation_time not found in token data when creating Token, setting creation time to now");
            this.localCreationTimestamp.setToNow();
            tokenData.put(KEY_CREATION_TIME, String.valueOf(this.localCreationTimestamp.toMillis(false)));
        } else {
            try {
                this.localCreationTimestamp.set(Long.parseLong(creationTimeMillis));
            }
            catch (NumberFormatException e) {
                MAPLog.e(LOG_TAG, "Unable to parse creation_time from token data when creating Token, setting creation time to now");
                this.localCreationTimestamp.setToNow();
                tokenData.put(KEY_CREATION_TIME, String.valueOf(this.localCreationTimestamp.toMillis(false)));
            }
        }
    }

    @Override
    public Time getLocalTimestamp() {
        return this.localCreationTimestamp;
    }

    protected final String getToken() {
        return this._token;
    }

    @Override
    public final Map<String, String> getData() {
        return this.tokenData;
    }

    public static AccountManagerConstants.REGION_HINT convertStringToRegionHint(String sRegionHint) {
        if (AccountManagerConstants.REGION_HINT.EU.toString().equalsIgnoreCase(sRegionHint)) {
            return AccountManagerConstants.REGION_HINT.EU;
        }
        if (AccountManagerConstants.REGION_HINT.FE.toString().equalsIgnoreCase(sRegionHint)) {
            return AccountManagerConstants.REGION_HINT.FE;
        }
        if (AccountManagerConstants.REGION_HINT.CN.toString().equalsIgnoreCase(sRegionHint)) {
            return AccountManagerConstants.REGION_HINT.CN;
        }
        return AccountManagerConstants.REGION_HINT.NA;
    }

    private void initTokenData() {
        this.tokenData.put("token", this._token);
        this.tokenData.put(KEY_CREATION_TIME, String.valueOf(this.localCreationTimestamp.toMillis(false)));
    }

    public static long secsToMillis(long seconds) {
        return seconds * 1000L;
    }

    protected static long millisToSecs(long milliSeconds) {
        return milliSeconds / 1000L;
    }

    @Override
    public String getDirectedId() {
        return this.tokenData.get("directedid");
    }
}

