/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.data;

import com.google.gson.Gson;

public class Event {
    Header header;
    Payload payload;

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public static String getSpeechRecognizerEvent() {
        Builder builder = new Builder();
        builder.setHeaderNamespace("SpeechRecognizer").setHeaderName("Recognize").setHeaderMessageId("messageId-123").setHeaderDialogRequestId("dialogRequest-321").setPayloadFormat("AUDIO_L16_RATE_16000_CHANNELS_1").setPayloadProfile("CLOSE_TALK");
        return builder.toJson();
    }

    public static String getVolumeChangedEvent(long volume, boolean isMute) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("Speaker").setHeaderName("VolumeChanged").setHeaderMessageId("messageId-123").setPayloadVolume(volume).setPayloadMuted(isMute);
        return builder.toJson();
    }

    public static String getMuteEvent(boolean isMute) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("Speaker").setHeaderName("VolumeChanged").setHeaderMessageId("messageId-123").setPayloadMuted(isMute);
        return builder.toJson();
    }

    public static String getExpectSpeechTimedOutEvent() {
        Builder builder = new Builder();
        builder.setHeaderNamespace("SpeechRecognizer").setHeaderName("ExpectSpeechTimedOut").setHeaderMessageId("messageId-123");
        return builder.toJson();
    }

    public static String getSynchronizeStateEvent() {
        Builder builder = new Builder();
        builder.setHeaderNamespace("System").setHeaderName("SynchronizeState").setHeaderMessageId("messageId-123");
        return builder.toJson();
    }

    public static class Builder {
        Event event = new Event();
        Payload payload = new Payload();
        Header header = new Header();

        public Builder() {
            this.event.setPayload(this.payload);
            this.event.setHeader(this.header);
        }

        public EventWrapper build() {
            EventWrapper wrapper = new EventWrapper();
            wrapper.event = this.event;
            return wrapper;
        }

        public String toJson() {
            return this.build().toJson();
        }

        public Builder setHeaderNamespace(String namespace) {
            this.header.namespace = namespace;
            return this;
        }

        public Builder setHeaderName(String name) {
            this.header.name = name;
            return this;
        }

        public Builder setHeaderMessageId(String messageId) {
            this.header.messageId = messageId;
            return this;
        }

        public Builder setHeaderDialogRequestId(String dialogRequestId) {
            this.header.dialogRequestId = dialogRequestId;
            return this;
        }

        public Builder setPayloadProfile(String profile) {
            this.payload.profile = profile;
            return this;
        }

        public Builder setPayloadFormat(String format) {
            this.payload.format = format;
            return this;
        }

        public Builder setPayloadMuted(boolean muted) {
            this.payload.muted = muted;
            return this;
        }

        public Builder setPayloadVolume(long volume) {
            this.payload.volume = volume;
            return this;
        }
    }

    public static class EventWrapper {
        Event event;

        public Event getEvent() {
            return this.event;
        }

        public String toJson() {
            return new Gson().toJson((Object)this) + "\n";
        }
    }

    public static class Payload {
        String profile;
        String format;
        boolean muted;
        long volume;

        public String getProfile() {
            return this.profile;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class Header {
        String namespace;
        String name;
        String messageId;
        String dialogRequestId;

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getDialogRequestId() {
            return this.dialogRequestId;
        }

        public void setDialogRequestId(String dialogRequestId) {
            this.dialogRequestId = dialogRequestId;
        }
    }
}

