/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractTokenRequest;
import com.amazon.identity.auth.device.endpoint.ProfileResponse;
import com.amazon.identity.auth.device.endpoint.TokenResponse;
import com.amazon.identity.auth.device.utils.DefaultLibraryInfo;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.AccountManagerConstants;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;

public class ProfileRequest
extends AbstractTokenRequest {
    private static final String LOG_TAG = ProfileRequest.class.getName();
    private static final String PROFILE_ENDPOINT = "/user/profile";
    private static final String BEARER_PREFIX = "Bearer ";
    private static final String AUTHORIZATION = "Authorization";
    private static final String API_PREFIX = "api";
    private static final Pattern HOST_PATTERN = Pattern.compile("https://(.*)\\.amazon\\.[^/]+");
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("\\.amazon\\.[^/]+");
    private String mAuthzToken;
    private final Context mContext;
    protected String mCustomHost;
    public static final String API_PREFIX_DEVO = "api.integ";
    public static final String API_PREFIX_PRE_PROD = "api.pre-prod";

    public ProfileRequest(String appName, String appVersion, String libVersion, Bundle options, String authzToken, Context context, AppInfo appInfo) {
        super(appName, appVersion, libVersion, options);
        this.mAuthzToken = authzToken;
        this.mContext = context;
        if (appInfo != null) {
            this.mCustomHost = appInfo.getExchangeHost();
        }
    }

    protected TokenResponse generateTokenResponse(HttpResponse httpResponse) {
        return new ProfileResponse(httpResponse);
    }

    protected void addRequestInfoParameters() throws AuthError {
    }

    public String getEndPoint() {
        return PROFILE_ENDPOINT;
    }

    public void initializeHeaders() throws AuthError {
        super.initializeHeaders();
        this.addHeader((Header)new BasicHeader(AUTHORIZATION, BEARER_PREFIX + this.mAuthzToken));
    }

    public String getDomain() {
        Matcher amazonDomainMatcher;
        if (!TextUtils.isEmpty((CharSequence)this.mCustomHost) && (amazonDomainMatcher = DOMAIN_PATTERN.matcher(this.mCustomHost)).find()) {
            return amazonDomainMatcher.group();
        }
        return ".amazon.com";
    }

    public String getHost(Bundle options) {
        String prefix = null;
        this.updateAppState();
        switch (DefaultLibraryInfo.getOverrideLibraryState()) {
            case FORCE_DEVO: {
                prefix = this.mSandboxMode != false ? "api-sandbox.integ" : API_PREFIX_DEVO;
                break;
            }
            case FORCE_PRE_PROD: {
                prefix = API_PREFIX_PRE_PROD;
                break;
            }
            default: {
                Matcher amazonDomainMatcher;
                if (!TextUtils.isEmpty((CharSequence)this.mCustomHost) && (amazonDomainMatcher = HOST_PATTERN.matcher(this.mCustomHost)).find()) {
                    prefix = amazonDomainMatcher.group(1);
                }
                if (!TextUtils.isEmpty((CharSequence)prefix)) break;
                prefix = this.mSandboxMode != false ? "api.sandbox" : API_PREFIX;
            }
        }
        String host = prefix + this.getDomain();
        MAPLog.i(LOG_TAG, "host for request: " + host);
        return host;
    }

    public HttpRequestBase getRequest() throws AuthError {
        return new HttpGet(this.getRequestUrl());
    }

    protected void consumeRequestContent() throws IOException {
    }

    protected void updateEntity() throws UnsupportedEncodingException, IOException {
    }

    private void updateAppState() {
        String hostType = MAPUtils.getHostType(this.mContext, this.mContext.getPackageName());
        if ("development".equalsIgnoreCase(hostType)) {
            DefaultLibraryInfo.setOverrideAppState(AccountManagerConstants.OVERIDE_APP_STATE.FORCE_DEVO);
        } else if ("gamma".equalsIgnoreCase(hostType)) {
            DefaultLibraryInfo.setOverrideAppState(AccountManagerConstants.OVERIDE_APP_STATE.FORCE_PRE_PROD);
        }
    }
}

