/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractTokenRequest;
import com.amazon.identity.auth.device.utils.DefaultLibraryInfo;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.AccountManagerConstants;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.message.BasicNameValuePair;

public abstract class AbstractOauthTokenRequest
extends AbstractTokenRequest {
    private static final String LOG_TAG = AbstractTokenRequest.class.getName();
    public static final String OAUTH_END_POINT = "/auth/o2/token";
    public static final String AUTHORIZATION_CODE_GRANT = "authorization_code";
    public static final String REFRESH_TOKEN_GRANT = "refresh_token";
    public static final String GRANT_TYPE_PARAM = "grant_type";
    public static final String AUTHORIZATION_CODE_PARAM = "code";
    public static final String REDIRECT_URI_PARAM = "redirect_uri";
    public static final String APP_CLIENT_ID_PARAM = "client_id";
    public static final String APP_APP_ID_PARAM = "app_id";
    public static final String API_PREFIX = "api";
    public static final String API_PREFIX_SANDBOX = "api.sandbox";
    public static final String API_PREFIX_DEVO = "api.integ";
    public static final String API_PREFIX_DEVO_SANDBOX = "api-sandbox.integ";
    public static final String API_PREFIX_PRE_PROD = "api.pre-prod";
    private final String mAppFamilyId;
    protected final String mClientId;
    protected String mCustomHost;
    protected final String mHostType;

    public AbstractOauthTokenRequest(String appName, String appVersion, String libVersion, Context context, Bundle options, AppInfo appInfo) throws AuthError {
        super(appName, appVersion, libVersion, options);
        if (appInfo == null) {
            throw new AuthError("Appinfo can not be null to make an OAuthTokenRequest", AuthError.ERROR_TYPE.ERROR_UNKNOWN);
        }
        this.mAppFamilyId = appInfo.getAppFamilyId();
        this.mHostType = MAPUtils.getHostType(context, context.getPackageName());
        this.mClientId = appInfo.getClientId();
        this.mCustomHost = appInfo.getExchangeHost();
        this.updateAppState();
    }

    public String getEndPoint() {
        return OAUTH_END_POINT;
    }

    public String getDomain() {
        return ".amazon.com";
    }

    public String getRequestUrl() throws AuthError {
        if (!DefaultLibraryInfo.isProd() || TextUtils.isEmpty((CharSequence)this.mCustomHost) || this.mSandboxMode.booleanValue()) {
            return super.getRequestUrl();
        }
        URL url = null;
        try {
            url = new URL(this.mCustomHost);
        }
        catch (MalformedURLException e) {
            throw new AuthError("MalformedURLException", e, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
        return url.toString();
    }

    public String getHost(Bundle options) {
        String prefix = null;
        this.updateAppState();
        switch (DefaultLibraryInfo.getOverrideLibraryState()) {
            case FORCE_DEVO: {
                prefix = this.mSandboxMode != false ? API_PREFIX_DEVO_SANDBOX : API_PREFIX_DEVO;
                break;
            }
            case FORCE_PRE_PROD: {
                prefix = API_PREFIX_PRE_PROD;
                break;
            }
            default: {
                prefix = this.mSandboxMode != false ? API_PREFIX_SANDBOX : API_PREFIX;
            }
        }
        String host = prefix + this.getDomain();
        MAPLog.i(LOG_TAG, "host for request: " + host);
        return host;
    }

    public abstract String getGrantType();

    private void updateAppState() {
        if ("development".equalsIgnoreCase(this.mHostType)) {
            DefaultLibraryInfo.setOverrideAppState(AccountManagerConstants.OVERIDE_APP_STATE.FORCE_DEVO);
        } else if ("gamma".equalsIgnoreCase(this.mHostType)) {
            DefaultLibraryInfo.setOverrideAppState(AccountManagerConstants.OVERIDE_APP_STATE.FORCE_PRE_PROD);
        }
    }

    protected void addRequestInfoParameters() throws AuthError {
        this.postParameters.add(new BasicNameValuePair(GRANT_TYPE_PARAM, this.getGrantType()));
        this.postParameters.add(new BasicNameValuePair(APP_CLIENT_ID_PARAM, this.mClientId));
    }

    protected String getAppFamilyId() {
        return this.mAppFamilyId;
    }
}

