/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.InvalidGrantAuthError;
import com.amazon.identity.auth.device.InvalidTokenAuthError;
import com.amazon.identity.auth.device.dataobject.AuthorizationToken;
import com.amazon.identity.auth.device.endpoint.AbstractJSONTokenResponse;
import com.amazon.identity.auth.device.token.AccessAtzToken;
import com.amazon.identity.auth.device.token.RefreshAtzToken;
import com.amazon.identity.auth.map.device.token.AbstractToken;
import com.amazon.identity.auth.map.device.token.Token;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

class OauthTokenResponse
extends AbstractJSONTokenResponse {
    private static final String LOG_TAG = OauthTokenResponse.class.getName();
    private static final String REQUEST_ID_HEADER = "x-amzn-RequestId";
    static final String AUTHZ_UNSUPPORTED_GRANT_TYPE = "unsupported_grant_type";
    static final String AUTHZ_INSUFFICIENT_SCOPE = "insufficient_scope";
    static final String AUTHZ_INVALID_TOKEN = "invalid_token";
    static final String AUTHZ_ERROR_DESCIRPTION = "error_description";
    static final String AUTHZ_INVALID_GRANT = "invalid_grant";
    static final String AUTHZ_INVALID_REQUEST = "invalid_request";
    static final String AUTHZ_ACCESS_TOKEN = "access_token";
    static final String AUTHZ_INVALID_CLIENT = "invalid_client";
    static final String AUTHZ_INVALID_SCOPE = "invalid_scope";
    static final String AUTHZ_UNAUTHORIZED_CLIENT = "unauthorized_client";
    private final String mAppFamilyId;
    protected AccessAtzToken mAccessToken;
    private RefreshAtzToken mRefreshToken = null;
    private String mDirectedId;

    OauthTokenResponse(HttpResponse response, String appFamilyId, String directedId) {
        super(response);
        this.mAppFamilyId = appFamilyId;
        this.mDirectedId = directedId;
    }

    public void testParse(JSONObject jResponse) throws IOException, JSONException, AuthError {
        this.doParse(jResponse);
    }

    protected void doParse(JSONObject jResponse) throws IOException, JSONException, AuthError {
        this.mAccessToken = this.extractAccessAtzToken(jResponse);
        this.mRefreshToken = this.extractRefreshAtzToken(jResponse);
    }

    public Token createPrimaryToken(String token, long expiresIn) {
        return new AccessAtzToken(this.mAppFamilyId, this.mDirectedId, token, expiresIn, null);
    }

    public AccessAtzToken extractAccessAtzToken(JSONObject jResponse) throws AuthError {
        String tokenVal;
        try {
            if (!jResponse.has(AUTHZ_ACCESS_TOKEN)) {
                MAPLog.e(LOG_TAG, "Unable to find AccessAtzToken in JSON response, throwing AuthError");
                throw new AuthError("JSON response did not contain an AccessAtzToken", AuthError.ERROR_TYPE.ERROR_JSON);
            }
            tokenVal = jResponse.getString(AUTHZ_ACCESS_TOKEN);
        }
        catch (JSONException e) {
            MAPLog.e(LOG_TAG, "Error reading JSON response, throwing AuthError");
            throw new AuthError("Error reading JSON response", AuthError.ERROR_TYPE.ERROR_JSON);
        }
        long expiresIn = this.getExpiresIn(jResponse);
        return (AccessAtzToken)this.createPrimaryToken(tokenVal, AbstractToken.secsToMillis(expiresIn));
    }

    public RefreshAtzToken extractRefreshAtzToken(JSONObject jResponse) throws AuthError {
        MAPLog.i(LOG_TAG, "Extracting RefreshToken");
        try {
            if (jResponse.has("refresh_token")) {
                String tokenVal = jResponse.getString("refresh_token");
                return new RefreshAtzToken(this.getAppFamilyId(), this.mDirectedId, tokenVal, null);
            }
            MAPLog.e(LOG_TAG, "Unable to find RefreshAtzToken in JSON response");
            return null;
        }
        catch (JSONException e) {
            MAPLog.e(LOG_TAG, "Error reading JSON response, throwing AuthError");
            throw new AuthError("Error reading JSON response", AuthError.ERROR_TYPE.ERROR_JSON);
        }
    }

    public String getAppFamilyId() {
        return this.mAppFamilyId;
    }

    public AccessAtzToken getAccessAtzToken() {
        return this.mAccessToken;
    }

    public RefreshAtzToken getRefreshAtzToken() {
        return this.mRefreshToken;
    }

    public AuthorizationToken[] getAtzTokens() {
        return new AuthorizationToken[]{this.mAccessToken, this.mRefreshToken};
    }

    protected JSONObject extractResponseJSONObject(JSONObject jsonObject) throws JSONException {
        try {
            return super.extractResponseJSONObject(jsonObject);
        }
        catch (JSONException e) {
            MAPLog.w(LOG_TAG, "No Response type in the response");
            return jsonObject;
        }
    }

    protected void handleJSONError(JSONObject jResponse) throws AuthError {
        block7: {
            String error = null;
            try {
                error = jResponse.getString("error");
                if (TextUtils.isEmpty((CharSequence)error)) break block7;
                String description = jResponse.getString(AUTHZ_ERROR_DESCIRPTION);
                if (this.isInvalidGrant(error, description)) {
                    String msg = "Invalid source authorization in exchange.";
                    MAPLog.pii(LOG_TAG, msg, "info=" + jResponse);
                    throw new InvalidGrantAuthError(msg + jResponse);
                }
                if (this.isInvalidToken(error, description)) {
                    this.handleInvalidToken(jResponse);
                    break block7;
                }
                if (this.isInvalidClient(error, description)) {
                    String msg = "Invalid Client. ApiKey is invalid ";
                    MAPLog.pii(LOG_TAG, msg, "info=" + jResponse);
                    throw new AuthError(msg + jResponse, AuthError.ERROR_TYPE.ERROR_INVALID_CLIENT);
                }
                if (this.isInvalidScope(error, description) || this.isInsufficientScope(error, description)) {
                    String msg = "Invalid Scope. Authorization not valid for the requested scopes ";
                    MAPLog.pii(LOG_TAG, msg, "info=" + jResponse);
                    throw new AuthError(msg + jResponse, AuthError.ERROR_TYPE.ERROR_INVALID_SCOPE);
                }
                if (this.isUnauthorizedClient(error, description)) {
                    String msg = "Unauthorizaied Client.  The authenticated client is not authorized to use this authorization grant type. ";
                    MAPLog.pii(LOG_TAG, msg, "info=" + jResponse);
                    throw new AuthError(msg + jResponse, AuthError.ERROR_TYPE.ERROR_UNAUTHORIZED_CLIENT);
                }
                String msg = "Server error doing authorization exchange. ";
                MAPLog.pii(LOG_TAG, msg, "info=" + jResponse);
                throw new AuthError(msg + jResponse, AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
            }
            catch (JSONException e) {
                if (TextUtils.isEmpty((CharSequence)error)) break block7;
                throw new AuthError("Server Error : " + error, AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
            }
        }
    }

    boolean isUnauthorizedClient(String error, String description) {
        return AUTHZ_UNAUTHORIZED_CLIENT.equals(error);
    }

    boolean isInvalidScope(String error, String description) {
        return AUTHZ_INVALID_SCOPE.equals(error);
    }

    boolean isInvalidClient(String error, String description) {
        return AUTHZ_INVALID_CLIENT.equals(error);
    }

    boolean isInvalidGrant(String error, String description) {
        return AUTHZ_INVALID_GRANT.equals(error) || AUTHZ_UNSUPPORTED_GRANT_TYPE.equals(error);
    }

    boolean isInsufficientScope(String error, String description) {
        return AUTHZ_INSUFFICIENT_SCOPE.equals(error);
    }

    boolean isInvalidToken(String error, String description) {
        return AUTHZ_INVALID_TOKEN.equals(error) || AUTHZ_INVALID_REQUEST.equals(error) && !TextUtils.isEmpty((CharSequence)description) && description.contains(AUTHZ_ACCESS_TOKEN);
    }

    protected void logRequestId(JSONObject jHttpResponse) {
        super.logRequestId(jHttpResponse);
        HttpResponse response = this.getResponse();
        Header header = response.getFirstHeader(REQUEST_ID_HEADER);
        if (header != null) {
            MAPLog.pii(LOG_TAG, "ExchangeRepsonse", "requestId=" + header.getValue());
        } else {
            MAPLog.w(LOG_TAG, "No RequestId in OAuthTokenRepsonse headers");
        }
    }

    void handleInvalidToken(JSONObject jResponse) throws InvalidTokenAuthError {
        String msg = "Invalid Token in exchange.";
        MAPLog.pii(LOG_TAG, msg, "info=" + jResponse);
        throw new InvalidTokenAuthError(msg + jResponse);
    }

    public String getVersion() {
        return "2.0.2";
    }
}

