/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.net.Uri;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.AuthorizationHelper;
import com.amazon.identity.auth.device.authorization.AuthorizationResponseParser;
import com.amazon.identity.auth.device.authorization.CallbackInfo;
import com.amazon.identity.auth.device.authorization.CodeChallengeWorkflow;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.map.device.utils.MAPLog;

@SuppressLint(value={"Registered"})
public class AuthorizationActivity
extends Activity {
    private static final String LOG_TAG = AuthorizationActivity.class.getName();
    private static final String CODE_KEY = "code";

    protected void onCreate(Bundle savedInstanceState) {
        block6: {
            super.onCreate(savedInstanceState);
            MAPLog.w(LOG_TAG, "onCreate");
            Uri uri = this.getIntent().getData();
            if (uri == null) {
                MAPLog.i(LOG_TAG, "uri is null onCreate - closing activity");
                this.finish();
                return;
            }
            AuthorizationResponseParser parser = new AuthorizationResponseParser();
            final CallbackInfo callbackIntentInfo = AuthorizationResponseParser.getCallbackInfo(uri.toString());
            if (uri != null && callbackIntentInfo != null) {
                MAPLog.pii(LOG_TAG, "Received response from WebBroswer for OAuth2 flow", "response=" + uri.toString());
                try {
                    Bundle result = parser.extractResultsBundle(uri.toString(), callbackIntentInfo.mRequestId, callbackIntentInfo.mRequestedScopes);
                    if (result.containsKey(AuthzConstants.BUNDLE_KEY.CAUSE_ID.val)) {
                        callbackIntentInfo.mlistener.onCancel(result);
                        this.finish();
                        return;
                    }
                    boolean shouldGetAuthCode = result.getBoolean(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val, false);
                    if (shouldGetAuthCode) {
                        AuthorizationHelper.sendAuthorizationCodeAsResponse(result.getString(CODE_KEY), callbackIntentInfo.mlistener);
                        this.finish();
                        return;
                    }
                    AuthorizationHelper helper = new AuthorizationHelper();
                    String codeVerifier = CodeChallengeWorkflow.getInstance().getCodeVerifier();
                    helper.doCodeForTokenExchange(this.getApplicationContext(), this.getPackageName(), codeVerifier, result, false, null, new TokenVendor(), new ThirdPartyAppIdentifier(), new AuthorizationListener(){

                        public void onSuccess(Bundle response) {
                            MAPLog.w(LOG_TAG, "Code for Token Exchange success");
                            if (callbackIntentInfo.mlistener != null) {
                                callbackIntentInfo.mlistener.onSuccess(response);
                            }
                        }

                        public void onError(AuthError e) {
                            MAPLog.w(LOG_TAG, "Code for Token Exchange Error. " + e.getMessage());
                            if (callbackIntentInfo.mlistener != null) {
                                callbackIntentInfo.mlistener.onError(e);
                            }
                        }

                        public void onCancel(Bundle cause) {
                            MAPLog.w(LOG_TAG, "Code for Token Exchange Cancel");
                            if (callbackIntentInfo.mlistener != null) {
                                callbackIntentInfo.mlistener.onCancel(cause);
                            }
                        }
                    });
                }
                catch (AuthError e) {
                    if (callbackIntentInfo.mlistener == null) break block6;
                    callbackIntentInfo.mlistener.onError(e);
                }
            }
        }
        this.finish();
    }
}

