/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.endpoint.APTokenRequest;
import com.amazon.identity.auth.device.endpoint.TokenResponse;
import com.amazon.identity.auth.device.utils.DefaultLibraryInfo;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTokenRequest
implements APTokenRequest {
    private static final String LOG_TAG = AbstractTokenRequest.class.getName();
    public static final String DI_HW_NAME = "di.hw.name";
    public static final String DI_HW_VERSION = "di.hw.version";
    public static final String DI_OS_NAME = "di.os.name";
    public static final String DI_OS_VERSION = "di.os.version";
    public static final String DI_SDK_VERSION = "di.sdk.version";
    public static final String APP_VERSION = "app_version";
    public static final String APP_NAME = "app_name";
    public static final String ANDROID_OS_NAME = "Android";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String REQUESTED_TOKEN_TYPE = "requested_token_type";
    public static final String SOURCE_TOKEN = "source_token";
    public static final String SOURCE_TOKEN_TYPE = "source_token_type";
    public static final String DMS_TOKEN = "dms_token";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String AUTH_COOKIES = "auth_cookies";
    public static final String RESP_COOKIES = "cookies";
    public static final String RESP_TOKENS = "tokens";
    public static final String DOMAIN = "domain";
    public static final String EXCHANGE_END_POINT = "/ap/exchangetoken";
    public static final String REVOKE_END_POINT = "/auth/signout";
    protected static final String POST = "POST";
    protected static final String PORT_SEPERATOR = ":";
    public static final int PROD_PORT = 443;
    public static final int DEV_PORT = 443;
    protected static final int NUM_RETRY_ATTEMPTS = 2;
    protected static final int MAX_NUM_POST_PARAMS = 10;
    public static final String DEFAULT_DOMAIN = ".amazon.com";
    public static final String DEVO_PREFIX = "development";
    public static final String PROD_PREFIX = "www";
    public static final String PRE_PROD_PREFIX = "pre-prod";
    public static final String DEFAULT_USER_AGENT = "AmazonAuthenticationSDK/3.5.1/Android/" + Build.VERSION.RELEASE + "/" + Build.MODEL;
    public static final String DEFAULT_WEBVIEW_USER_AGENT = "AmazonWebView/AmazonAuthenticationSDK/3.5.1/Android/" + Build.VERSION.RELEASE + "/" + Build.MODEL;
    public static final String HTTPS = "https";
    protected HttpClient httpClient;
    protected HttpRequestBase mHttpRequest;
    private int socketTimeout = -1;
    protected final List<NameValuePair> postParameters;
    private String _domain = null;
    private Bundle mOptions;
    private String mAppName;
    private String mAppVersion;
    private String mLibVersion;
    protected final List<Header> _headers = new ArrayList<Header>();
    protected Boolean mSandboxMode = false;

    public AbstractTokenRequest(String appName, String appVersion, String libVersion, Bundle options) {
        this.postParameters = new ArrayList<NameValuePair>(10);
        this.mOptions = options;
        this.mAppName = appName;
        this.mAppVersion = appVersion;
        this.mLibVersion = libVersion;
        if (options != null) {
            this.mSandboxMode = options.getBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, false);
        }
    }

    @Override
    public void initializeHttp() throws AuthError {
        if (this.httpClient == null) {
            this.httpClient = DefaultLibraryInfo.isDevo() ? new UnsafeSslHttpClient() : new DefaultHttpClient();
            this.mHttpRequest = this.getRequest();
        }
    }

    @Override
    public void initializeUserAgent() {
        this.httpClient.getParams().setParameter("http.useragent", (Object)DEFAULT_USER_AGENT);
    }

    @Override
    public void preExecute() throws AuthError {
    }

    @Override
    public void postExecute(HttpResponse httpResponse) throws AuthError {
    }

    protected abstract TokenResponse generateTokenResponse(HttpResponse var1);

    @Override
    public List<NameValuePair> getPostParameters() {
        for (NameValuePair parameter : this.postParameters) {
            if (parameter != null) {
                MAPLog.pii(LOG_TAG, "Parameter Added to request", "name=" + parameter.getName() + " val=" + parameter.getValue());
                continue;
            }
            MAPLog.e(LOG_TAG, "Parameter Added to request was NULL");
        }
        return this.postParameters;
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    @Override
    public final TokenResponse submit() throws AuthError {
        this.initializeHttp();
        this.initializeUserAgent();
        this.initializePostParams();
        this.initializeHeaders();
        this.initializeCookies();
        try {
            this.updateEntity();
            Header[] headers = this.getHeaders();
            if (headers.length > 0) {
                this.mHttpRequest.setHeaders(headers);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new AuthError(uee.getMessage(), uee, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
        catch (IOException e) {
            throw new AuthError("Received IO error when creating RequestUrlBuilder", e, AuthError.ERROR_TYPE.ERROR_IO);
        }
        this.preExecute();
        HttpResponse response = null;
        try {
            MAPLog.i(LOG_TAG, "Request url: " + this.mHttpRequest.getURI());
            for (int attempt = 0; attempt <= 2 && AbstractTokenRequest.hasReceived500(response = this.executeRequest()); ++attempt) {
                if (attempt != 2) {
                    response.getEntity().consumeContent();
                }
                MAPLog.w(LOG_TAG, "Received " + AbstractTokenRequest.getCode(response) + " error on request attempt " + (attempt + 1) + " of " + 3);
            }
        }
        catch (ClientProtocolException cpe) {
            MAPLog.e(LOG_TAG, "Received communication error when executing token request:" + cpe.toString());
            throw new AuthError("Received communication error when executing token request", cpe, AuthError.ERROR_TYPE.ERROR_COM);
        }
        catch (IOException ioe) {
            MAPLog.e(LOG_TAG, "Received IO error when executing token request:" + ioe.toString());
            throw new AuthError("Received communication error when executing token request", ioe, AuthError.ERROR_TYPE.ERROR_IO);
        }
        catch (IllegalStateException ise) {
            MAPLog.e(LOG_TAG, "Received IllegalStateException error when executing token request:" + ise.toString());
            throw new AuthError("Received communication error when executing token request", ise, AuthError.ERROR_TYPE.ERROR_COM);
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.getConnectionManager().closeIdleConnections(5L, TimeUnit.SECONDS);
            }
            if (this.mHttpRequest != null) {
                try {
                    this.consumeRequestContent();
                }
                catch (IOException e) {
                    MAPLog.e(LOG_TAG, "IOException consuming httppost entity content " + e.toString());
                }
            }
        }
        this.postExecute(response);
        return this.generateTokenResponse(response);
    }

    public HttpRequestBase getRequest() throws AuthError {
        return new HttpPost(this.getRequestUrl());
    }

    protected void consumeRequestContent() throws IOException {
        ((HttpPost)this.mHttpRequest).getEntity().consumeContent();
    }

    protected void updateEntity() throws UnsupportedEncodingException, IOException {
        StringEntity entity = this.getEntity();
        ((HttpPost)this.mHttpRequest).setEntity((HttpEntity)entity);
    }

    public StringEntity getEntity() throws UnsupportedEncodingException, IOException {
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(this.getPostParameters());
        return urlEncodedFormEntity;
    }

    @Override
    public HttpResponse executeRequest() throws ClientProtocolException, IOException {
        if (this.socketTimeout != -1) {
            HttpParams params = this.mHttpRequest.getParams();
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.socketTimeout);
            this.mHttpRequest.setParams(params);
        }
        this.logRequestInfo();
        return this.httpClient.execute((HttpUriRequest)this.mHttpRequest);
    }

    private void logRequestInfo() {
        String userAgent = (String)this.httpClient.getParams().getParameter("http.useragent");
        MAPLog.pii(LOG_TAG, "Logging Request info.", "UserAgent = " + userAgent);
        Header[] headers = this.mHttpRequest.getAllHeaders();
        if (headers != null) {
            MAPLog.i(LOG_TAG, "Number of Headers : " + headers.length);
            for (Header header : headers) {
                MAPLog.pii(LOG_TAG, "Header used for request: name=" + header.getName(), "val=" + header.getValue());
            }
        } else {
            MAPLog.i(LOG_TAG, "No Headers");
        }
    }

    private static boolean hasReceived500(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return code >= 500 && code < 600;
    }

    private static int getCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    @Override
    public Header[] getHeaders() {
        Header[] headerArray = new Header[this._headers.size()];
        this._headers.toArray(headerArray);
        return headerArray;
    }

    @Override
    public void initializePostParams() throws AuthError {
        this.addRequestInfoParameters();
        this.addAppInfoParameters();
        this.addDeviceParams();
    }

    protected void addDeviceParams() throws AuthError {
        if (!TextUtils.isEmpty((CharSequence)Build.MANUFACTURER) && !Build.MANUFACTURER.equals("unknown")) {
            this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_HW_NAME, Build.MANUFACTURER));
        }
        if (!TextUtils.isEmpty((CharSequence)Build.MODEL) && !Build.MODEL.equals("unknown")) {
            this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_HW_VERSION, Build.MODEL));
        }
        this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_OS_NAME, ANDROID_OS_NAME));
        if (!TextUtils.isEmpty((CharSequence)Build.VERSION.RELEASE) && !Build.VERSION.RELEASE.equals("unknown")) {
            this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_OS_VERSION, Build.VERSION.RELEASE));
        }
        this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_SDK_VERSION, this.mLibVersion));
    }

    protected void addAppInfoParameters() throws AuthError {
        this.postParameters.add((NameValuePair)new BasicNameValuePair(APP_NAME, this.mAppName));
        if (this.mAppVersion != null) {
            this.postParameters.add((NameValuePair)new BasicNameValuePair(APP_VERSION, this.mAppVersion));
        }
    }

    @Override
    public String getVerbAsString() {
        return POST;
    }

    @Override
    public int getPort() {
        return AbstractTokenRequest.getRequestPort();
    }

    public static int getRequestPort() {
        if (DefaultLibraryInfo.isProd()) {
            return 443;
        }
        return 443;
    }

    protected void initializeCookies() {
    }

    protected void addHeader(Header header) {
        this._headers.add(header);
    }

    protected abstract void addRequestInfoParameters() throws AuthError;

    @Override
    public String getDomain() {
        return this._domain;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public abstract String getEndPoint();

    @Override
    public String getRequestUrl() throws AuthError {
        URL url = null;
        String host = this.getHost(this.mOptions);
        int port = this.getPort();
        String endPoint = this.getEndPoint();
        try {
            url = new URL(HTTPS, host, port, endPoint);
        }
        catch (MalformedURLException e) {
            throw new AuthError("MalformedURLException", e, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
        return url.toString();
    }

    @Override
    public String getHost(Bundle options) {
        return AbstractTokenRequest.getRequestHost(this.getDomain(), options);
    }

    public static String getRequestHost(String domain, Bundle options) {
        String requestDomain = domain;
        if (requestDomain == null) {
            MAPLog.i(LOG_TAG, "No domain passed into Request, Attempting to get from options");
            if (options != null) {
                requestDomain = options.getString("com.amazon.identity.ap.domain");
            }
        }
        if (requestDomain == null) {
            requestDomain = DEFAULT_DOMAIN;
            MAPLog.i(LOG_TAG, "No domain in options");
        }
        String prefix = null;
        switch (DefaultLibraryInfo.getOverrideLibraryState()) {
            case FORCE_DEVO: {
                prefix = "";
                break;
            }
            case FORCE_PRE_PROD: {
                prefix = "";
                break;
            }
            default: {
                prefix = PROD_PREFIX;
            }
        }
        String host = prefix + requestDomain;
        return host;
    }

    @Override
    public void initializeHeaders() throws AuthError {
        this._headers.addAll(this.getDefaultHeaders());
    }

    protected List<Header> getDefaultHeaders() {
        ArrayList<Header> opfHeaders = new ArrayList<Header>();
        opfHeaders.add((Header)new BasicHeader("Accept-Encoding", "gzip, deflate"));
        opfHeaders.add((Header)new BasicHeader("Accept-Language", "en-us,en;q=0.5"));
        opfHeaders.add((Header)new BasicHeader("Accept", "application/xml,application/xhtml+xml,text/html,application/json;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5"));
        opfHeaders.add((Header)new BasicHeader("Accept-Charset", "utf-8, iso-8859-1, utf-16, *;q=0.7"));
        return opfHeaders;
    }

    private class UnsafeSslHttpClient
    extends DefaultHttpClient {
        private static final String BKS = "BKS";
        private static final String HTTPS = "https";

        private SSLSocketFactory newSslSocketFactory() {
            try {
                KeyStore trusted = KeyStore.getInstance(BKS);
                MySSLSocketFactory factory = new MySSLSocketFactory(trusted);
                factory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                return factory;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        protected ClientConnectionManager createClientConnectionManager() {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("https", (SocketFactory)this.newSslSocketFactory(), 443));
            return new SingleClientConnManager(this.getParams(), registry);
        }

        public class MySSLSocketFactory
        extends SSLSocketFactory {
            SSLContext sslContext;

            public MySSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
                super(truststore);
                this.sslContext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                this.sslContext.init(null, new TrustManager[]{tm}, null);
            }

            public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
                return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
            }

            public Socket createSocket() throws IOException {
                return this.sslContext.getSocketFactory().createSocket();
            }
        }
    }
}

