/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.util.Base64;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

class CodeChallengeWorkflow {
    private static final String LOG_TAG = CodeChallengeWorkflow.class.getName();
    private static final String SHA_256 = "S256";
    private static final String ALORITHM_SHA_256 = "SHA-256";
    private static final String PLAIN = "plain";
    private String codeVerifier;
    private String codeChallengeMethod;
    private String codeChallenge;
    private static CodeChallengeWorkflow instance;
    public static final String CODE_CHALLENGE_KEY = "code_challenge";
    public static final String CODE_CHALLENGE_METHOD_KEY = "code_challenge_method";

    private CodeChallengeWorkflow() {
    }

    public static CodeChallengeWorkflow getInstance() {
        if (instance == null) {
            instance = new CodeChallengeWorkflow();
        }
        return instance;
    }

    public Bundle getProofKeyParameters() {
        this.codeVerifier = this.generateCodeVerifier();
        try {
            this.codeChallengeMethod = SHA_256;
            this.codeChallenge = this.generateCodeChallenge(this.codeVerifier, this.codeChallengeMethod);
        }
        catch (NoSuchAlgorithmException e) {
            MAPLog.e(LOG_TAG, "Error generating Proof Key parmeter", e);
            this.codeChallengeMethod = PLAIN;
            this.codeChallenge = this.codeVerifier;
        }
        Bundle proofKeyParameters = new Bundle();
        proofKeyParameters.putString(CODE_CHALLENGE_METHOD_KEY, this.codeChallengeMethod);
        proofKeyParameters.putString(CODE_CHALLENGE_KEY, this.codeChallenge);
        return proofKeyParameters;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    private String generateCodeChallenge(String codeVerifier, String codeChallengeMethod) throws NoSuchAlgorithmException {
        String codeChallenge = SHA_256.equalsIgnoreCase(codeChallengeMethod) ? this.base64UrlEncode(MessageDigest.getInstance(ALORITHM_SHA_256).digest(codeVerifier.getBytes())) : codeVerifier;
        return codeChallenge;
    }

    private String generateCodeVerifier() {
        byte[] randomOctetSequence = this.generateRandomOctetSequence();
        String codeVerifier = this.base64UrlEncode(randomOctetSequence);
        return codeVerifier;
    }

    @SuppressLint(value={"TrulyRandom"})
    private byte[] generateRandomOctetSequence() {
        SecureRandom random = new SecureRandom();
        byte[] octetSequence = new byte[32];
        random.nextBytes(octetSequence);
        return octetSequence;
    }

    private String base64UrlEncode(byte[] arg) {
        return Base64.encodeToString((byte[])arg, (int)11);
    }
}

