/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.audioplayer;

import android.content.Context;
import android.media.MediaPlayer;
import android.util.Log;
import com.willblaschko.android.alexa.interfaces.AvsItem;
import com.willblaschko.android.alexa.interfaces.audioplayer.AvsPlayContentItem;
import com.willblaschko.android.alexa.interfaces.audioplayer.AvsPlayRemoteItem;
import com.willblaschko.android.alexa.interfaces.speechsynthesizer.AvsSpeakItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AlexaAudioPlayer {
    public static final String TAG = "AlexaAudioPlayer";
    private static AlexaAudioPlayer mInstance;
    private MediaPlayer mMediaPlayer;
    private Context mContext;
    private AvsItem mItem;
    private List<Callback> mCallbacks = new ArrayList<Callback>();
    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            for (Callback callback : AlexaAudioPlayer.this.mCallbacks) {
                callback.itemComplete(AlexaAudioPlayer.this.mItem);
            }
        }
    };
    private MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            for (Callback callback : AlexaAudioPlayer.this.mCallbacks) {
                callback.playerPrepared(AlexaAudioPlayer.this.mItem);
            }
            AlexaAudioPlayer.this.mMediaPlayer.start();
        }
    };
    private MediaPlayer.OnErrorListener mErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int what, int extra) {
            for (Callback callback : AlexaAudioPlayer.this.mCallbacks) {
                boolean response = callback.playerError(what, extra);
                if (!response) continue;
                return response;
            }
            return false;
        }
    };

    private AlexaAudioPlayer(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public static AlexaAudioPlayer getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new AlexaAudioPlayer(context);
        }
        return mInstance;
    }

    private MediaPlayer getMediaPlayer() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setWakeMode(this.mContext, 1);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
        }
        return this.mMediaPlayer;
    }

    public void addCallback(Callback callback) {
        if (!this.mCallbacks.contains(callback)) {
            this.mCallbacks.add(callback);
        }
    }

    public void removeCallback(Callback callback) {
        this.mCallbacks.remove(callback);
    }

    public void playItem(AvsPlayContentItem item) {
        this.play(item);
    }

    public void playItem(AvsSpeakItem item) {
        this.play(item);
    }

    public void playItem(AvsPlayRemoteItem item) {
        this.play(item);
    }

    private void play(AvsItem item) {
        AvsItem playItem;
        if (this.isPlaying()) {
            Log.w((String)TAG, (String)"Already playing an item, did you mean to play another?");
        }
        this.mItem = item;
        if (this.getMediaPlayer().isPlaying()) {
            this.getMediaPlayer().stop();
        }
        if (this.mItem instanceof AvsPlayRemoteItem) {
            playItem = (AvsPlayRemoteItem)item;
            try {
                this.getMediaPlayer().reset();
                this.getMediaPlayer().setAudioStreamType(3);
                this.getMediaPlayer().setDataSource(((AvsPlayRemoteItem)playItem).getUrl());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.bubbleUpError(e);
            }
        } else if (this.mItem instanceof AvsPlayContentItem) {
            playItem = (AvsPlayContentItem)item;
            try {
                this.getMediaPlayer().reset();
                this.getMediaPlayer().setAudioStreamType(3);
                this.getMediaPlayer().setDataSource(this.mContext, ((AvsPlayContentItem)playItem).getUri());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.bubbleUpError(e);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                this.bubbleUpError(e);
            }
        } else if (this.mItem instanceof AvsSpeakItem) {
            playItem = (AvsSpeakItem)item;
            File path = new File(this.mContext.getCacheDir() + "/playfile.3gp");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(path);
                fos.write(((AvsSpeakItem)playItem).getAudio());
                fos.close();
                this.getMediaPlayer().reset();
                this.getMediaPlayer().setDataSource(this.mContext.getCacheDir() + "/playfile.3gp");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.bubbleUpError(e);
            }
        }
        try {
            this.getMediaPlayer().prepareAsync();
        }
        catch (IllegalStateException e) {
            this.bubbleUpError(e);
        }
    }

    public boolean isPlaying() {
        return this.getMediaPlayer().isPlaying();
    }

    public void pause() {
        this.getMediaPlayer().pause();
    }

    public void play() {
        this.getMediaPlayer().start();
    }

    public void stop() {
        this.getMediaPlayer().stop();
    }

    public void release() {
        if (this.mMediaPlayer != null) {
            if (this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
        }
        this.mMediaPlayer = null;
    }

    private void bubbleUpError(Exception e) {
        for (Callback callback : this.mCallbacks) {
            callback.dataError(e);
        }
    }

    public static interface Callback {
        public void playerPrepared(AvsItem var1);

        public void itemComplete(AvsItem var1);

        public boolean playerError(int var1, int var2);

        public void dataError(Exception var1);
    }
}

