/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.os.Bundle;
import android.os.IInterface;
import android.text.TextUtils;
import android.util.Log;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.APIKeyDecoder;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.AmazonServiceListener;
import com.amazon.identity.auth.device.authorization.ThirdPartyAuthorizationServiceConnection;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import com.amazon.identity.auth.map.device.utils.MAPVersion;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThirdPartyServiceHelper {
    private static final String LOG_TAG = ThirdPartyServiceHelper.class.getName();
    static String DEVO_FINGERPRINT = "7cac391937981b6134bdce1fd9834c253181f5abf91ded6078210d0f91ace360";
    private static String PROD_FINGERPRINT = "2f19adeb284eb36f7f07786152b9a1d14b21653203ad0b04ebbf9c73ab6d7625";
    private static final String BINDING_ERROR_MESSAGE = "Binding to authorization service has timed out!";
    private static final String AUTHORIZATION_SERVICE_INTENT_ACTION_NAME = "com.amazon.identity.auth.device.authorization.MapAuthorizationService";
    private static final long CONNECTION_TIMEOUT = 10L;
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IInterface getAuthorizationServiceInstance(Context context, boolean forceRefresh) throws AuthError {
        if (ThreadUtils.isRunningOnMainThread()) {
            MAPLog.e(LOG_TAG, "getAuthorizationServiceInstance started on main thread");
            throw new IllegalStateException("getAuthorizationServiceInstance started on main thread");
        }
        MAPLog.d(LOG_TAG, "getAuthorizationServiceInstance");
        MAPServiceInfo previousMapServiceInfo = null;
        Object object = lock;
        synchronized (object) {
            if (forceRefresh) {
                previousMapServiceInfo = HighestVersionedService.getMAPServiceInfo();
                if (previousMapServiceInfo != null) {
                    ThirdPartyServiceHelper.safeUnbind(context, previousMapServiceInfo.getConnection(), previousMapServiceInfo.getServiceIntent());
                    HighestVersionedService.setMAPServiceInfo(null);
                }
            } else {
                MAPServiceInfo mapServiceInfo = HighestVersionedService.getMAPServiceInfo();
                if (mapServiceInfo != null) {
                    ThirdPartyServiceHelper.safeUnbind(context, mapServiceInfo.getConnection(), mapServiceInfo.getServiceIntent());
                    boolean bindSuccessful = this.bindHighestVersionedService(context);
                    if (bindSuccessful) {
                        return mapServiceInfo.getService();
                    }
                    HighestVersionedService.setMAPServiceInfo(null);
                }
            }
        }
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent();
        intent.setAction(AUTHORIZATION_SERVICE_INTENT_ACTION_NAME);
        List intentServices = packageManager.queryIntentServices(intent, 0);
        MAPLog.i(LOG_TAG, "Number of services found : " + intentServices.size());
        List<MAPServiceInfo> mapServiceInfoList = this.getAllAuthorizationServices(context, intentServices, previousMapServiceInfo);
        IInterface serviceInterface = null;
        Object object2 = lock;
        synchronized (object2) {
            HighestVersionedService.setMAPServiceInfo(this.findAuthorizationService(mapServiceInfoList));
            if (HighestVersionedService.getMAPServiceInfo() == null) {
                MAPLog.i(LOG_TAG, "Returning no service to use");
                return null;
            }
            this.bindHighestVersionedService(context);
            MAPLog.i(LOG_TAG, "Returning service to use");
            MAPServiceInfo mapServiceInfo = HighestVersionedService.getMAPServiceInfo();
            if (mapServiceInfo != null) {
                serviceInterface = mapServiceInfo.getService();
            }
        }
        return serviceInterface;
    }

    List<MAPServiceInfo> getAllAuthorizationServices(Context context, List<ResolveInfo> intentServices, MAPServiceInfo previousMapServiceInfo) throws AuthError {
        ArrayList<MAPServiceInfo> mapServiceInfoList = new ArrayList<MAPServiceInfo>();
        for (ResolveInfo resolveInfo : intentServices) {
            if (previousMapServiceInfo == null || !resolveInfo.serviceInfo.applicationInfo.packageName.equals(((MAPServiceInfo)previousMapServiceInfo).mResolveInfo.serviceInfo.applicationInfo.packageName)) {
                try {
                    MAPLog.i(LOG_TAG, "Verifying signature for pkg=" + resolveInfo.serviceInfo.applicationInfo.packageName);
                    PackageInfo pkgSignatureInfo = context.getPackageManager().getPackageInfo(resolveInfo.serviceInfo.applicationInfo.packageName, 64);
                    Signature[] signatures = pkgSignatureInfo.signatures;
                    if (signatures.length == 1) {
                        if (!ThirdPartyServiceHelper.isFingerprintValid(context, signatures)) {
                            MAPLog.pii(LOG_TAG, "Security check failure", "Signature is incorrect.");
                            continue;
                        }
                    } else {
                        MAPLog.pii(LOG_TAG, "Security count failure", "Signature count (" + signatures.length + ") is incorrect.");
                        continue;
                    }
                    ComponentName componentName = new ComponentName(resolveInfo.serviceInfo.applicationInfo.packageName, resolveInfo.serviceInfo.name);
                    Bundle metaDataBundle = context.getPackageManager().getServiceInfo((ComponentName)componentName, (int)128).metaData;
                    if (metaDataBundle == null) continue;
                    boolean isPrimary = metaDataBundle.getBoolean("map.primary");
                    String version = metaDataBundle.getString("map.version");
                    if (TextUtils.isEmpty((CharSequence)version) && !isPrimary) continue;
                    MAPVersion mapVersion = isPrimary ? MAPVersion.VERSION_ZERO : new MAPVersion(version);
                    ThirdPartyAuthorizationServiceConnection serviceConnection = new ThirdPartyAuthorizationServiceConnection();
                    MAPServiceInfo mapServiceInfo = new MAPServiceInfo(mapVersion, null, serviceConnection, isPrimary, resolveInfo, new Intent().setComponent(componentName));
                    if (isPrimary) {
                        mapServiceInfoList.clear();
                        mapServiceInfoList.add(mapServiceInfo);
                        break;
                    }
                    mapServiceInfoList.add(mapServiceInfo);
                }
                catch (PackageManager.NameNotFoundException e1) {
                    MAPLog.pii(LOG_TAG, "NameNotFoundException.", "msg=" + e1.getMessage());
                }
                continue;
            }
            MAPLog.i(LOG_TAG, "Ignoring previous service =" + resolveInfo.serviceInfo.name);
        }
        return mapServiceInfoList;
    }

    private static boolean isFingerprintValid(Context context, Signature[] signatures) {
        if (MAPUtils.isDevo(context)) {
            MAPLog.i(LOG_TAG, "Attempting to check fingerprint in development environment");
            return ThirdPartyServiceHelper.isSameSignatureFingerprint(DEVO_FINGERPRINT, signatures[0]);
        }
        MAPLog.i(LOG_TAG, "Attempting to check fingerprint in production environment");
        return ThirdPartyServiceHelper.isSameSignatureFingerprint(PROD_FINGERPRINT, signatures[0]);
    }

    static boolean isSameSignatureFingerprint(String fingerprint, Signature signature) {
        try {
            String sigFingerprint = APIKeyDecoder.getSignatureFingerprint(signature, APIKeyDecoder.HashAlgorithm.SHA_256);
            MAPLog.pii(LOG_TAG, "Expected fingerprint", "Fingerprint=" + fingerprint);
            MAPLog.pii(LOG_TAG, "Extracted fingerprint", "Fingerprint=" + sigFingerprint);
            return fingerprint.equals(sigFingerprint);
        }
        catch (CertificateException e) {
            MAPLog.pii(LOG_TAG, "CertificateException getting Fingerprint. ", e.getMessage());
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            MAPLog.pii(LOG_TAG, "NoSuchAlgorithmException getting Fingerprint. ", e.getMessage());
            return false;
        }
        catch (IOException e) {
            MAPLog.pii(LOG_TAG, "IOException getting Fingerprint. ", e.getMessage());
            return false;
        }
    }

    boolean bindHighestVersionedService(Context context) throws AuthError {
        block5: {
            if (HighestVersionedService.isServiceCacheStale()) {
                return false;
            }
            final MAPServiceInfo mapServiceInfo = HighestVersionedService.getMAPServiceInfo();
            ServiceInfo serviceInfo = ((MAPServiceInfo)mapServiceInfo).getResolveInfo().serviceInfo;
            ComponentName componentName = new ComponentName(serviceInfo.applicationInfo.packageName, serviceInfo.name);
            final Intent serviceIntent = new Intent();
            serviceIntent.setComponent(componentName);
            final ThirdPartyAuthorizationServiceConnection serviceConnection = new ThirdPartyAuthorizationServiceConnection();
            final CountDownLatch latch = new CountDownLatch(1);
            serviceConnection.setServiceListener(new AmazonServiceListener(){

                public void onBindSuccess(IInterface serviceInterface) {
                    mapServiceInfo.setService(serviceInterface);
                    mapServiceInfo.setConnection(serviceConnection);
                    mapServiceInfo.setServiceIntent(serviceIntent);
                    latch.countDown();
                }

                public void onBindError(AuthError authError) {
                    mapServiceInfo.setService(null);
                    mapServiceInfo.setConnection(null);
                    mapServiceInfo.setServiceIntent(null);
                    MAPLog.i(LOG_TAG, "Bind - error");
                    latch.countDown();
                }
            });
            boolean success = context.bindService(serviceIntent, (ServiceConnection)serviceConnection, 5);
            if (success) {
                try {
                    MAPLog.i(LOG_TAG, "Awaiting latch");
                    if (!latch.await(10L, TimeUnit.SECONDS)) {
                        MAPLog.w(LOG_TAG, "Unable to establish bind within timelimit = 10");
                        HighestVersionedService.setMAPServiceInfo(null);
                        throw new AuthError(BINDING_ERROR_MESSAGE, AuthError.ERROR_TYPE.ERROR_THREAD);
                    }
                    break block5;
                }
                catch (InterruptedException e) {
                    MAPLog.pii(LOG_TAG, "InterruptedException", "msg+=" + e.getMessage());
                    HighestVersionedService.setMAPServiceInfo(null);
                    throw new AuthError(BINDING_ERROR_MESSAGE, e, AuthError.ERROR_TYPE.ERROR_THREAD);
                }
            }
            HighestVersionedService.setMAPServiceInfo(null);
            MAPLog.w(LOG_TAG, "Bind Service " + serviceIntent.getComponent().flattenToString() + "unsuccessful");
        }
        return true;
    }

    MAPServiceInfo findAuthorizationService(List<MAPServiceInfo> mapServiceInfoList) {
        MAPLog.i(LOG_TAG, "Number of MAP services to compare = " + mapServiceInfoList.size());
        MAPServiceInfo serviceResult = null;
        for (MAPServiceInfo mapServiceInfo : mapServiceInfoList) {
            if (mapServiceInfo.isPrimary()) {
                MAPLog.i(LOG_TAG, "Returning Primary Service");
                return mapServiceInfo;
            }
            if (serviceResult == null) {
                serviceResult = mapServiceInfo;
                continue;
            }
            if (mapServiceInfo.getMapVersion().compare(serviceResult.getMapVersion()) <= 0) continue;
            serviceResult = mapServiceInfo;
        }
        return serviceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unbind(Context context) {
        Object object = lock;
        synchronized (object) {
            MAPLog.i(LOG_TAG, "Unbinding Highest Versioned Service");
            MAPServiceInfo mapServiceInfo = HighestVersionedService.getMAPServiceInfo();
            if (mapServiceInfo != null && mapServiceInfo.getConnection() != null) {
                ThirdPartyServiceHelper.safeUnbind(context, mapServiceInfo.getConnection(), mapServiceInfo.getServiceIntent());
                mapServiceInfo.setService(null);
                mapServiceInfo.setConnection(null);
                mapServiceInfo.setServiceIntent(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCachedService(Context context) {
        Object object = lock;
        synchronized (object) {
            MAPLog.i(LOG_TAG, "Clearing Highest Versioned Service");
            MAPServiceInfo mapServiceInfo = HighestVersionedService.getMAPServiceInfo();
            if (mapServiceInfo != null) {
                ThirdPartyServiceHelper.safeUnbind(context, mapServiceInfo.getConnection(), mapServiceInfo.getServiceIntent());
                HighestVersionedService.setMAPServiceInfo(null);
            }
        }
    }

    public static void safeUnbind(Context context, ServiceConnection connection, Intent serviceIntent) {
        String packageName = null;
        if (serviceIntent != null) {
            packageName = serviceIntent.getComponent().getPackageName();
        }
        MAPLog.d(LOG_TAG, "Unbinding pkg=" + packageName);
        try {
            if (connection != null) {
                context.unbindService(connection);
            }
        }
        catch (IllegalArgumentException e) {
            Log.w((String)LOG_TAG, (String)String.format("IllegalArgumentException is received during unbinding from %s. Ignored.", packageName));
        }
    }

    public AmazonAuthorizationServiceInterface getRemoteAndroidService(Context context, boolean forceRefresh) throws AuthError {
        MAPLog.i(LOG_TAG, "Attempting to retrieve remote Android service. Ignore cached service=" + forceRefresh);
        return (AmazonAuthorizationServiceInterface)this.getAuthorizationServiceInstance(context, forceRefresh);
    }

    class MAPServiceInfo {
        private final MAPVersion mMapVersion;
        private IInterface mService;
        private ThirdPartyAuthorizationServiceConnection mConnection;
        private Intent mServiceIntent;
        private final boolean mIsPrimary;
        private final ResolveInfo mResolveInfo;

        public MAPServiceInfo(MAPVersion mapVersion, IInterface service, ThirdPartyAuthorizationServiceConnection connection, boolean isPrimary, ResolveInfo resolveInfo, Intent serviceIntent) {
            this.mMapVersion = mapVersion;
            this.mService = service;
            this.setConnection(connection);
            this.mIsPrimary = isPrimary;
            this.mResolveInfo = resolveInfo;
            this.mServiceIntent = serviceIntent;
        }

        public MAPVersion getMapVersion() {
            return this.mMapVersion;
        }

        public void setService(IInterface service) {
            this.mService = service;
        }

        public IInterface getService() {
            return this.mService;
        }

        public ThirdPartyAuthorizationServiceConnection getConnection() {
            return this.mConnection;
        }

        public boolean isPrimary() {
            return this.mIsPrimary;
        }

        private ResolveInfo getResolveInfo() {
            return this.mResolveInfo;
        }

        private void setConnection(ThirdPartyAuthorizationServiceConnection mConnection) {
            this.mConnection = mConnection;
        }

        public void setServiceIntent(Intent serviceIntent) {
            this.mServiceIntent = serviceIntent;
        }

        public Intent getServiceIntent() {
            return this.mServiceIntent;
        }
    }

    static class HighestVersionedService {
        static MAPServiceInfo mapServiceInfo = null;
        static long serviceDiscoveryTimestamp = 0L;

        HighestVersionedService() {
        }

        public static MAPServiceInfo getMAPServiceInfo() {
            return mapServiceInfo;
        }

        static void setMAPServiceInfo(MAPServiceInfo serviceInfo) {
            mapServiceInfo = serviceInfo;
            serviceDiscoveryTimestamp = serviceInfo == null ? 0L : new Date().getTime();
        }

        static boolean isServiceCacheStale() {
            if (mapServiceInfo == null) {
                return true;
            }
            long now = new Date().getTime();
            return now > serviceDiscoveryTimestamp + 86400000L;
        }
    }

    public static final class TOKEN_KEYS {
        public static final String ACCESS_ATZ_TOKEN = "accessAtzToken";
        public static final String ACCESS_ATZ_EXPIRES_IN = "accessAtzToken.expiries_in";
        public static final String REFRESH_ATZ_TOKEN = "refreshAtzToken";
    }
}

