/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device;

import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.amazon.identity.auth.device.IAuthError;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthError
extends Exception
implements Parcelable,
IAuthError {
    private static final String LOG_TAG = AuthError.class.getName();
    private static final long serialVersionUID = 1L;
    public static final String AUTH_ERROR_EXECEPTION = "AUTH_ERROR_EXECEPTION";
    public static final int RESULT_AUTH_ERROR = 1;
    private final ERROR_TYPE _type;
    public static final Parcelable.Creator<AuthError> CREATOR = new Parcelable.Creator<AuthError>(){

        public AuthError createFromParcel(Parcel in) {
            String detailMessage = in.readString();
            Throwable throwable = (Throwable)in.readValue(Throwable.class.getClassLoader());
            ERROR_TYPE type = (ERROR_TYPE)((Object)in.readSerializable());
            if (type == ERROR_TYPE.ERROR_UNKNOWN) {
                type = ERROR_TYPE.fromValue(in.readInt());
            }
            return new AuthError(detailMessage, throwable, type);
        }

        public AuthError[] newArray(int size) {
            return new AuthError[size];
        }
    };

    public AuthError(String detailMessage, ERROR_TYPE type) {
        super(detailMessage);
        this._type = type;
    }

    public AuthError(String detailMessage, Throwable throwable, ERROR_TYPE type) {
        super(detailMessage, throwable);
        this._type = type;
    }

    public ERROR_CATEGORY getCategory() {
        return this._type.getCategory();
    }

    public ERROR_TYPE getType() {
        return this._type;
    }

    @Override
    public String toString() {
        return "AuthError cat= " + (Object)((Object)this._type.getCategory()) + " type=" + (Object)((Object)this._type) + " - " + super.toString();
    }

    public int describeContents() {
        return 0;
    }

    public AuthError(Parcel source) {
        this(source.readString(), (Throwable)source.readValue(Throwable.class.getClassLoader()), (ERROR_TYPE)((Object)source.readSerializable()));
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getMessage());
        if (this.getCause() != null) {
            dest.writeValue((Object)this.getCause());
        } else {
            dest.writeValue(null);
        }
        if (this._type.value() < ERROR_TYPE.ERROR_CODE_V2) {
            dest.writeSerializable((Serializable)((Object)this._type));
        } else {
            dest.writeSerializable((Serializable)((Object)ERROR_TYPE.ERROR_UNKNOWN));
        }
        dest.writeInt(this._type.value());
    }

    public static AuthError extractError(Intent intent) {
        AuthError authError = null;
        try {
            authError = (AuthError)intent.getParcelableExtra(AUTH_ERROR_EXECEPTION);
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "Error Extracting AuthError");
        }
        return authError;
    }

    public static AuthError extractError(Bundle bundle) {
        AuthError authError = null;
        try {
            authError = (AuthError)bundle.getParcelable(AUTH_ERROR_EXECEPTION);
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "Error Extracting AuthError");
        }
        return authError;
    }

    public static Bundle getErrorBundle(AuthError e) {
        Bundle errorBundle = new Bundle();
        errorBundle.putParcelable(AUTH_ERROR_EXECEPTION, (Parcelable)e);
        return errorBundle;
    }

    public static Bundle getErrorBundle(Intent intent) {
        return AuthError.getErrorBundle(AuthError.extractError(intent));
    }

    public static <T> Bundle getErrorBundle(Throwable throwable, Class<T> c, ERROR_TYPE authErrorType) {
        return AuthError.getErrorBundle(AuthError.getAuthError(throwable, c, authErrorType));
    }

    public static <T> AuthError getAuthError(Throwable throwable, Class<T> c) {
        return AuthError.getAuthError(throwable, c, ERROR_TYPE.ERROR_UNKNOWN);
    }

    public static <T> AuthError getAuthError(Throwable throwable, Class<T> c, ERROR_TYPE type) {
        return new AuthError("Unexpected error in " + c.getName(), throwable, type);
    }

    public IBinder asBinder() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ERROR_TYPE {
        ERROR_INVALID_TOKEN(ERROR_CATEGORY.ACTION, 1),
        ERROR_INVALID_GRANT(ERROR_CATEGORY.ACTION, 2),
        ERROR_INVALID_CLIENT(ERROR_CATEGORY.ACTION, 3),
        ERROR_INVALID_SCOPE(ERROR_CATEGORY.ACTION, 4),
        ERROR_UNAUTHORIZED_CLIENT(ERROR_CATEGORY.ACTION, 5),
        ERROR_WEBVIEW_SSL(ERROR_CATEGORY.ACTION, 6),
        ERROR_ACCESS_DENIED(ERROR_CATEGORY.ACTION, 7),
        ERROR_COM(ERROR_CATEGORY.NETWORK, 8),
        ERROR_IO(ERROR_CATEGORY.NETWORK, 9),
        ERROR_BAD_PARAM(ERROR_CATEGORY.INTERNAL, 10),
        ERROR_JSON(ERROR_CATEGORY.INTERNAL, 11),
        ERROR_PARSE(ERROR_CATEGORY.INTERNAL, 12),
        ERROR_SERVER_REPSONSE(ERROR_CATEGORY.INTERNAL, 13),
        ERROR_DATA_STORAGE(ERROR_CATEGORY.INTERNAL, 14),
        ERROR_THREAD(ERROR_CATEGORY.INTERNAL, 15),
        ERROR_DCP_DMS(ERROR_CATEGORY.ACTION, 16),
        ERROR_FORCE_UPDATE(ERROR_CATEGORY.ACTION, 17),
        ERROR_REVOKE_AUTH(ERROR_CATEGORY.INTERNAL, 18),
        ERROR_AUTH_DIALOG(ERROR_CATEGORY.INTERNAL, 19),
        ERROR_BAD_API_PARAM(ERROR_CATEGORY.BAD_REQUEST, 20),
        ERROR_INIT(ERROR_CATEGORY.BAD_REQUEST, 21),
        ERROR_RESOURCES(ERROR_CATEGORY.BAD_REQUEST, 22),
        ERROR_DIRECTED_ID_NOT_FOUND(ERROR_CATEGORY.BAD_REQUEST, 23),
        ERROR_INVALID_API(ERROR_CATEGORY.BAD_REQUEST, 24),
        ERROR_SECURITY(ERROR_CATEGORY.BAD_REQUEST, 25),
        ERROR_UNKNOWN(ERROR_CATEGORY.UNKNOWN, 26),
        ERROR_REGISTRATION(ERROR_CATEGORY.ACTION, 27),
        ERROR_MISSING_CODE_CHALLENGE(ERROR_CATEGORY.BAD_REQUEST, 28);

        private static int ERROR_CODE_V2;
        private final ERROR_CATEGORY _category;
        private final int _value;

        private ERROR_TYPE(ERROR_CATEGORY category, int value) {
            this._category = category;
            this._value = value;
        }

        public ERROR_CATEGORY getCategory() {
            return this._category;
        }

        public int value() {
            return this._value;
        }

        public static ERROR_TYPE fromValue(int value) {
            for (ERROR_TYPE error : ERROR_TYPE.values()) {
                if (error.value() != value) continue;
                return error;
            }
            return ERROR_UNKNOWN;
        }

        static {
            ERROR_CODE_V2 = 27;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ERROR_CATEGORY {
        ACTION,
        BAD_REQUEST,
        NETWORK,
        INTERNAL,
        UNKNOWN;

    }
}

