/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.interfaces.response;

import android.util.Log;
import com.google.gson.Gson;
import com.willblaschko.android.alexa.data.Directive;
import com.willblaschko.android.alexa.interfaces.AvsException;
import com.willblaschko.android.alexa.interfaces.AvsItem;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.alerts.AvsSetAlertItem;
import com.willblaschko.android.alexa.interfaces.audioplayer.AvsPlayAudioItem;
import com.willblaschko.android.alexa.interfaces.audioplayer.AvsPlayRemoteItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsMediaNextCommandItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsMediaPauseCommandItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsMediaPlayCommandItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsMediaPreviousCommandItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsReplaceAllItem;
import com.willblaschko.android.alexa.interfaces.playbackcontrol.AvsReplaceEnqueuedItem;
import com.willblaschko.android.alexa.interfaces.speaker.AvsAdjustVolumeItem;
import com.willblaschko.android.alexa.interfaces.speaker.AvsSetMuteItem;
import com.willblaschko.android.alexa.interfaces.speaker.AvsSetVolumeItem;
import com.willblaschko.android.alexa.interfaces.speechrecognizer.AvsExpectSpeechItem;
import com.willblaschko.android.alexa.interfaces.speechsynthesizer.AvsSpeakItem;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;

public class ResponseParser {
    public static final String TAG = "ResponseParser";

    public static AvsResponse parseResponse(InputStream stream, String boundary) throws IOException, IllegalStateException, AvsException {
        long start = System.currentTimeMillis();
        ArrayList<Directive> directives = new ArrayList<Directive>();
        HashMap<String, ByteArrayInputStream> audio = new HashMap<String, ByteArrayInputStream>();
        MultipartStream mpStream = new MultipartStream(stream, boundary.getBytes(), 100000, null);
        Pattern pattern = Pattern.compile("<(.*?)>");
        if (!mpStream.skipPreamble()) {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)stream, (Writer)writer, (Charset)Charset.defaultCharset());
            String body = writer.toString();
            throw new AvsException("Response from Alexa server malformed.");
        }
        Log.i((String)TAG, (String)"Found initial boundary: true");
        for (int count = 0; count < 1 || mpStream.readBoundary(); ++count) {
            String headers = mpStream.readHeaders();
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            mpStream.readBodyData((OutputStream)data);
            if (!ResponseParser.isJson(headers)) {
                Matcher matcher;
                String string2 = ResponseParser.getCID(headers);
                if (string2 == null || !(matcher = pattern.matcher(string2)).find()) continue;
                String currentId = "cid:" + matcher.group(1);
                audio.put(currentId, new ByteArrayInputStream(data.toByteArray()));
                continue;
            }
            String string3 = data.toString(Charset.defaultCharset().displayName());
            directives.add(ResponseParser.getDirective(string3));
        }
        AvsResponse response = new AvsResponse();
        for (Directive directive : directives) {
            ByteArrayInputStream sound;
            Log.i((String)TAG, (String)("Parsing directive type: " + directive.getHeader().getNamespace() + ":" + directive.getHeader().getName()));
            if (directive.isPlayBehaviorReplaceAll()) {
                response.add(0, new AvsReplaceAllItem());
            }
            if (directive.isPlayBehaviorReplaceEnqueued()) {
                response.add(new AvsReplaceEnqueuedItem());
            }
            AvsItem item = null;
            if (directive.isTypeSpeak()) {
                String cid = directive.getPayload().getUrl();
                sound = (ByteArrayInputStream)audio.get(cid);
                item = new AvsSpeakItem(cid, sound);
            } else if (directive.isTypePlay()) {
                String url = directive.getPayload().getAudioItem().getStream().getUrl();
                if (url.contains("cid:")) {
                    sound = (ByteArrayInputStream)audio.get(url);
                    item = new AvsPlayAudioItem(url, sound);
                } else {
                    item = new AvsPlayRemoteItem(url, directive.getPayload().getAudioItem().getStream().getOffsetInMilliseconds());
                }
            } else if (directive.isTypeSetAlert()) {
                item = new AvsSetAlertItem(directive.getPayload().getToken(), directive.getPayload().getType(), directive.getPayload().getScheduledTime());
                response.add(item);
            } else if (directive.isTypeSetMute()) {
                item = new AvsSetMuteItem(directive.getPayload().isMute());
            } else if (directive.isTypeSetVolume()) {
                item = new AvsSetVolumeItem(directive.getPayload().getVolume());
            } else if (directive.isTypeAdjustVolume()) {
                item = new AvsAdjustVolumeItem(directive.getPayload().getVolume());
            } else if (directive.isTypeExpectSpeech()) {
                item = new AvsExpectSpeechItem(directive.getPayload().getTimeoutInMilliseconds());
            } else if (directive.isTypeMediaPlay()) {
                item = new AvsMediaPlayCommandItem();
            } else if (directive.isTypeMediaPause()) {
                item = new AvsMediaPauseCommandItem();
            } else if (directive.isTypeMediaNext()) {
                item = new AvsMediaNextCommandItem();
            } else if (directive.isTypeMediaPrevious()) {
                item = new AvsMediaPreviousCommandItem();
            }
            if (item == null) continue;
            response.add(item);
        }
        Log.i((String)TAG, (String)("Parsing response took: " + (System.currentTimeMillis() - start)));
        return response;
    }

    private static Directive getDirective(String directive) {
        Gson gson = new Gson();
        Directive.DirectiveWrapper wrapper = (Directive.DirectiveWrapper)gson.fromJson(directive, Directive.DirectiveWrapper.class);
        return wrapper.getDirective();
    }

    private static String getCID(String headers) throws IOException {
        String contentString = "Content-ID:";
        BufferedReader reader = new BufferedReader(new StringReader(headers));
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("Content-ID:")) {
                return line.substring("Content-ID:".length()).trim();
            }
            line = reader.readLine();
        }
        return null;
    }

    private static boolean isJson(String headers) {
        return headers.contains("application/json");
    }
}

