/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization.api;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.ProfileHelper;
import com.amazon.identity.auth.device.authorization.ThirdPartyAuthorizationHelper;
import com.amazon.identity.auth.device.authorization.TokenHelper;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.thread.AuthzCallbackFuture;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.Arrays;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonAuthorizationManager {
    private static final String LOG_TAG = AmazonAuthorizationManager.class.getName();
    private static final String REDIRECT_URI_PREFIX = "amzn://";
    private final String mClientId;
    private final Context mContext;
    private final ThirdPartyAppIdentifier mAppIdentifier = new ThirdPartyAppIdentifier();
    private final String SDK_VERSION = "2.0.1";
    private final TokenVendor mTokenVendor;
    private Boolean mSandboxMode = false;

    public AmazonAuthorizationManager(Context context, Bundle options) {
        AppInfo appInfo;
        MAPLog.pii(LOG_TAG, "AmazonAuthorizationManager:sdkVer=2.0.1 libVer=3.5.1", "options=" + options);
        if (context == null) {
            throw new IllegalArgumentException("context must not be null!");
        }
        this.mContext = context;
        if (options == null) {
            MAPLog.i(LOG_TAG, "Options bundle is null");
        }
        if ((appInfo = this.mAppIdentifier.getAppInfo(this.mContext.getPackageName(), this.mContext)) == null || appInfo.getClientId() == null) {
            throw new IllegalArgumentException("Invalid API Key");
        }
        this.mClientId = appInfo.getClientId();
        this.mTokenVendor = new TokenVendor();
        if (options != null) {
            this.mSandboxMode = options.getBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, false);
        }
    }

    public Future<Bundle> authorize(String[] scopes, Bundle options, AuthorizationListener listener) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException("scopes must not be null or empty!");
        }
        if (options == null) {
            options = new Bundle();
        }
        Bundle allOptions = new Bundle(options);
        allOptions.putBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, this.mSandboxMode.booleanValue());
        return this.doAuthorize(scopes, allOptions, listener);
    }

    private Future<Bundle> doAuthorize(final String[] scopes, final Bundle options, final AuthorizationListener listener) {
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling authorize with Activity: scopes=" + Arrays.toString(scopes));
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                if (!AmazonAuthorizationManager.this.isAPIKeyValid()) {
                    listener.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                    return;
                }
                ThirdPartyAuthorizationHelper authzHelper = new ThirdPartyAuthorizationHelper();
                try {
                    authzHelper.authorize(AmazonAuthorizationManager.this.mContext, AmazonAuthorizationManager.this.mContext.getPackageName(), AmazonAuthorizationManager.this.mClientId, scopes, true, AmazonAuthorizationManager.this.mTokenVendor, listener, options);
                }
                catch (AuthError e) {
                    listener.onError(e);
                }
            }
        });
        return null;
    }

    public Future<Bundle> getToken(final String[] scopes, APIListener listener) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException("scopes must not be null or empty!");
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getToken : scopes=" + Arrays.toString(scopes));
        final AuthzCallbackFuture callbackFuture = new AuthzCallbackFuture(listener);
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                try {
                    if (!AmazonAuthorizationManager.this.isAPIKeyValid()) {
                        callbackFuture.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                        return;
                    }
                    Bundle options = new Bundle();
                    options.putBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, AmazonAuthorizationManager.this.mSandboxMode.booleanValue());
                    TokenHelper.getToken(AmazonAuthorizationManager.this.mContext, AmazonAuthorizationManager.this.mContext.getPackageName(), AmazonAuthorizationManager.this.mClientId, scopes, new APIListener(){

                        public void onSuccess(Bundle response) {
                            callbackFuture.onSuccess(response);
                        }

                        public void onError(AuthError e) {
                            callbackFuture.onError(e);
                        }
                    }, new ThirdPartyAppIdentifier(), options);
                }
                catch (AuthError e) {
                    callbackFuture.onError(e);
                }
            }
        });
        return callbackFuture;
    }

    public String getAppId() throws AuthError {
        if (!this.isAPIKeyValid()) {
            throw new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED);
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getAppId");
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        AppInfo appInfo = appIdentifier.getAppInfo(this.mContext.getPackageName(), this.mContext);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getAppFamilyId();
    }

    public String getAppVariantId() throws AuthError {
        if (!this.isAPIKeyValid()) {
            throw new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED);
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getAppId");
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        AppInfo appInfo = appIdentifier.getAppInfo(this.mContext.getPackageName(), this.mContext);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getAppVariantId();
    }

    public String getClientId() throws AuthError {
        if (!this.isAPIKeyValid()) {
            throw new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED);
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getClientId");
        return this.mClientId;
    }

    public String getRedirectUri() throws AuthError {
        if (!this.isAPIKeyValid()) {
            throw new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED);
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getRedirectUri");
        return REDIRECT_URI_PREFIX + this.mContext.getPackageName();
    }

    public Future<Bundle> clearAuthorizationState(APIListener listener) {
        final AuthzCallbackFuture callbackFuture = new AuthzCallbackFuture(listener);
        if (!this.isAPIKeyValid()) {
            callbackFuture.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling clearAuthorizationState");
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AuthError tempError = null;
                try {
                    DatabaseHelper.clearServiceAuthorizationState(AmazonAuthorizationManager.this.mContext);
                }
                catch (AuthError e) {
                    tempError = e;
                }
                finally {
                    DatabaseHelper.clearAuthorizationState(AmazonAuthorizationManager.this.mContext);
                    if (tempError != null) {
                        callbackFuture.onError(tempError);
                    } else {
                        callbackFuture.onSuccess(new Bundle());
                    }
                }
            }
        });
        return callbackFuture;
    }

    public Future<Bundle> getProfile(APIListener listener) {
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getProfile");
        final AuthzCallbackFuture callbackFuture = new AuthzCallbackFuture(listener);
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                if (!AmazonAuthorizationManager.this.isAPIKeyValid()) {
                    callbackFuture.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                    return;
                }
                Bundle options = new Bundle();
                if (AmazonAuthorizationManager.this.mSandboxMode.booleanValue()) {
                    options.putBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, AmazonAuthorizationManager.this.mSandboxMode.booleanValue());
                }
                ProfileHelper.getProfile(AmazonAuthorizationManager.this.mContext, AmazonAuthorizationManager.this.mContext.getPackageName(), options, new APIListener(){

                    public void onSuccess(Bundle response) {
                        callbackFuture.onSuccess(response);
                    }

                    public void onError(AuthError e) {
                        callbackFuture.onError(e);
                    }
                });
            }
        });
        return callbackFuture;
    }

    private boolean isAPIKeyValid() {
        return this.mAppIdentifier.isAPIKeyValid(this.mContext) ? this.mClientId != null : false;
    }
}

